/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth;

import java.net.URI;
import java.security.Provider;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSAlgorithm;
import macromedia.externals.com.nimbusds.jwt_8_2_1.SignedJWT;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ParseException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.assertions.jwt.JWTAssertionDetails;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.assertions.jwt.JWTAssertionFactory;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth.ClientAuthenticationMethod;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth.JWTAuthentication;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth.JWTAuthenticationClaimsSet;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.CommonContentTypes;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.HTTPRequest;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.id.Audience;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.id.ClientID;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.util.URLUtils;
import net.jcip.annotations.Immutable;

/*
 * Exception performing whole class analysis ignored.
 */
@Immutable
public final class PrivateKeyJWT
extends JWTAuthentication {
    public static Set<JWSAlgorithm> supportedJWAs() {
        HashSet hashSet = new HashSet();
        hashSet.addAll(JWSAlgorithm.Family.RSA);
        hashSet.addAll(JWSAlgorithm.Family.EC);
        return Collections.unmodifiableSet(hashSet);
    }

    public PrivateKeyJWT(ClientID clientID, URI uRI, JWSAlgorithm jWSAlgorithm, RSAPrivateKey rSAPrivateKey, String string, Provider provider) throws JOSEException {
        this(new JWTAuthenticationClaimsSet(clientID, new Audience(uRI.toString())), jWSAlgorithm, rSAPrivateKey, string, provider);
    }

    public PrivateKeyJWT(JWTAuthenticationClaimsSet jWTAuthenticationClaimsSet, JWSAlgorithm jWSAlgorithm, RSAPrivateKey rSAPrivateKey, String string, Provider provider) throws JOSEException {
        this(JWTAssertionFactory.create((JWTAssertionDetails)jWTAuthenticationClaimsSet, (JWSAlgorithm)jWSAlgorithm, (RSAPrivateKey)rSAPrivateKey, (String)string, (Provider)provider));
    }

    public PrivateKeyJWT(ClientID clientID, URI uRI, JWSAlgorithm jWSAlgorithm, ECPrivateKey eCPrivateKey, String string, Provider provider) throws JOSEException {
        this(new JWTAuthenticationClaimsSet(clientID, new Audience(uRI.toString())), jWSAlgorithm, eCPrivateKey, string, provider);
    }

    public PrivateKeyJWT(JWTAuthenticationClaimsSet jWTAuthenticationClaimsSet, JWSAlgorithm jWSAlgorithm, ECPrivateKey eCPrivateKey, String string, Provider provider) throws JOSEException {
        this(JWTAssertionFactory.create((JWTAssertionDetails)jWTAuthenticationClaimsSet, (JWSAlgorithm)jWSAlgorithm, (ECPrivateKey)eCPrivateKey, (String)string, (Provider)provider));
    }

    public PrivateKeyJWT(SignedJWT signedJWT) {
        super(ClientAuthenticationMethod.PRIVATE_KEY_JWT, signedJWT);
        JWSAlgorithm jWSAlgorithm = signedJWT.getHeader().getAlgorithm();
        if (!JWSAlgorithm.Family.RSA.contains((Object)jWSAlgorithm) && !JWSAlgorithm.Family.EC.contains((Object)jWSAlgorithm)) {
            throw new IllegalArgumentException("The client assertion JWT must be RSA or ECDSA-signed (RS256, RS384, RS512, PS256, PS384, PS512, ES256, ES384 or ES512)");
        }
    }

    public static PrivateKeyJWT parse(Map<String, String> map) throws ParseException {
        PrivateKeyJWT privateKeyJWT;
        JWTAuthentication.ensureClientAssertionType(map);
        SignedJWT signedJWT = JWTAuthentication.parseClientAssertion(map);
        try {
            privateKeyJWT = new PrivateKeyJWT(signedJWT);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException(illegalArgumentException.getMessage(), (Throwable)illegalArgumentException);
        }
        ClientID clientID = JWTAuthentication.parseClientID(map);
        if (clientID != null && !clientID.equals((Object)privateKeyJWT.getClientID())) {
            throw new ParseException("Invalid private key JWT authentication: The client identifier doesn't match the client assertion subject / issuer");
        }
        return privateKeyJWT;
    }

    public static PrivateKeyJWT parse(String string) throws ParseException {
        Map map = URLUtils.parseParameters((String)string);
        return PrivateKeyJWT.parse((Map)map);
    }

    public static PrivateKeyJWT parse(HTTPRequest hTTPRequest) throws ParseException {
        hTTPRequest.ensureMethod(HTTPRequest.Method.POST);
        hTTPRequest.ensureContentType(CommonContentTypes.APPLICATION_URLENCODED);
        return PrivateKeyJWT.parse((Map)hTTPRequest.getQueryParameters());
    }

    public static /* bridge */ /* synthetic */ JWTAuthentication parse(HTTPRequest hTTPRequest) throws ParseException {
        return PrivateKeyJWT.parse((HTTPRequest)hTTPRequest);
    }
}

