/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth;

import java.util.HashMap;
import java.util.Map;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSAlgorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSObject;
import macromedia.externals.com.nimbusds.jwt_8_2_1.JWTClaimsSet;
import macromedia.externals.com.nimbusds.jwt_8_2_1.SignedJWT;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ParseException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.SerializeException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth.ClientAuthentication;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth.ClientAuthenticationMethod;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth.ClientSecretJWT;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth.JWTAuthenticationClaimsSet;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth.PrivateKeyJWT;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.CommonContentTypes;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.HTTPRequest;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.id.ClientID;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.util.URLUtils;
import macromedia.externals.javax.mail_1_4_7.internet.ContentType;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class JWTAuthentication
extends ClientAuthentication {
    public static final String CLIENT_ASSERTION_TYPE = "urn:ietf:params:oauth:client-assertion-type:jwt-bearer";
    private final SignedJWT clientAssertion;
    private final JWTAuthenticationClaimsSet jwtAuthClaimsSet;

    private static ClientID parseClientID(SignedJWT signedJWT) {
        String string;
        String string2;
        try {
            string2 = signedJWT.getJWTClaimsSet().getSubject();
            string = signedJWT.getJWTClaimsSet().getIssuer();
        }
        catch (java.text.ParseException parseException) {
            throw new IllegalArgumentException(parseException.getMessage(), parseException);
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Missing subject in client JWT assertion");
        }
        if (string == null) {
            throw new IllegalArgumentException("Missing issuer in client JWT assertion");
        }
        if (!string2.equals(string)) {
            throw new IllegalArgumentException("Issuer and subject in client JWT assertion must designate the same client identifier");
        }
        return new ClientID(string2);
    }

    protected JWTAuthentication(ClientAuthenticationMethod clientAuthenticationMethod, SignedJWT signedJWT) {
        super(clientAuthenticationMethod, JWTAuthentication.parseClientID((SignedJWT)signedJWT));
        if (!signedJWT.getState().equals((Object)JWSObject.State.SIGNED)) {
            throw new IllegalArgumentException("The client assertion JWT must be signed");
        }
        this.clientAssertion = signedJWT;
        try {
            this.jwtAuthClaimsSet = JWTAuthenticationClaimsSet.parse((JWTClaimsSet)signedJWT.getJWTClaimsSet());
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception.getMessage(), exception);
        }
    }

    public SignedJWT getClientAssertion() {
        return this.clientAssertion;
    }

    public JWTAuthenticationClaimsSet getJWTAuthenticationClaimsSet() {
        return this.jwtAuthClaimsSet;
    }

    public Map<String, String> toParameters() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            hashMap.put("client_assertion", this.clientAssertion.serialize());
        }
        catch (IllegalStateException illegalStateException) {
            throw new SerializeException("Couldn't serialize JWT to a client assertion string: " + illegalStateException.getMessage(), (Throwable)illegalStateException);
        }
        hashMap.put("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer");
        return hashMap;
    }

    public void applyTo(HTTPRequest hTTPRequest) {
        if (hTTPRequest.getMethod() != HTTPRequest.Method.POST) {
            throw new SerializeException("The HTTP request method must be POST");
        }
        ContentType contentType = hTTPRequest.getContentType();
        if (contentType == null) {
            throw new SerializeException("Missing HTTP Content-Type header");
        }
        if (!contentType.match(CommonContentTypes.APPLICATION_URLENCODED)) {
            throw new SerializeException("The HTTP Content-Type header must be " + CommonContentTypes.APPLICATION_URLENCODED);
        }
        Map map = hTTPRequest.getQueryParameters();
        map.putAll(this.toParameters());
        String string = URLUtils.serializeParameters((Map)map);
        hTTPRequest.setQuery(string);
    }

    protected static void ensureClientAssertionType(Map<String, String> map) throws ParseException {
        String string = map.get("client_assertion_type");
        if (string == null) {
            throw new ParseException("Missing \"client_assertion_type\" parameter");
        }
        if (!string.equals("urn:ietf:params:oauth:client-assertion-type:jwt-bearer")) {
            throw new ParseException("Invalid \"client_assertion_type\" parameter, must be urn:ietf:params:oauth:client-assertion-type:jwt-bearer");
        }
    }

    protected static SignedJWT parseClientAssertion(Map<String, String> map) throws ParseException {
        String string = map.get("client_assertion");
        if (string == null) {
            throw new ParseException("Missing \"client_assertion\" parameter");
        }
        try {
            return SignedJWT.parse((String)string);
        }
        catch (java.text.ParseException parseException) {
            throw new ParseException("Invalid \"client_assertion\" JWT: " + parseException.getMessage(), (Throwable)parseException);
        }
    }

    protected static ClientID parseClientID(Map<String, String> map) {
        String string = map.get("client_id");
        if (string == null) {
            return null;
        }
        return new ClientID(string);
    }

    public static JWTAuthentication parse(HTTPRequest hTTPRequest) throws ParseException {
        hTTPRequest.ensureMethod(HTTPRequest.Method.POST);
        hTTPRequest.ensureContentType(CommonContentTypes.APPLICATION_URLENCODED);
        String string = hTTPRequest.getQuery();
        if (string == null) {
            throw new ParseException("Missing HTTP POST request entity body");
        }
        Map map = URLUtils.parseParameters((String)string);
        JWSAlgorithm jWSAlgorithm = JWTAuthentication.parseClientAssertion((Map)map).getHeader().getAlgorithm();
        if (ClientSecretJWT.supportedJWAs().contains(jWSAlgorithm)) {
            return ClientSecretJWT.parse((Map)map);
        }
        if (PrivateKeyJWT.supportedJWAs().contains(jWSAlgorithm)) {
            return PrivateKeyJWT.parse((Map)map);
        }
        throw new ParseException("Unsupported signed JWT algorithm: " + jWSAlgorithm);
    }

    public static /* bridge */ /* synthetic */ ClientAuthentication parse(HTTPRequest hTTPRequest) throws ParseException {
        return JWTAuthentication.parse((HTTPRequest)hTTPRequest);
    }
}

