/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth;

import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSAlgorithm;
import macromedia.externals.com.nimbusds.jwt_8_2_1.SignedJWT;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ParseException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.assertions.jwt.JWTAssertionDetails;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.assertions.jwt.JWTAssertionFactory;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth.ClientAuthenticationMethod;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth.JWTAuthentication;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth.JWTAuthenticationClaimsSet;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth.Secret;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.CommonContentTypes;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.HTTPRequest;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.id.Audience;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.id.ClientID;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.util.URLUtils;
import net.jcip.annotations.Immutable;

/*
 * Exception performing whole class analysis ignored.
 */
@Immutable
public final class ClientSecretJWT
extends JWTAuthentication {
    public static Set<JWSAlgorithm> supportedJWAs() {
        HashSet hashSet = new HashSet();
        hashSet.addAll(JWSAlgorithm.Family.HMAC_SHA);
        return Collections.unmodifiableSet(hashSet);
    }

    public ClientSecretJWT(ClientID clientID, URI uRI, JWSAlgorithm jWSAlgorithm, Secret secret) throws JOSEException {
        this(JWTAssertionFactory.create((JWTAssertionDetails)new JWTAuthenticationClaimsSet(clientID, new Audience(uRI.toString())), (JWSAlgorithm)jWSAlgorithm, (Secret)secret));
    }

    public ClientSecretJWT(SignedJWT signedJWT) {
        super(ClientAuthenticationMethod.CLIENT_SECRET_JWT, signedJWT);
        if (!JWSAlgorithm.Family.HMAC_SHA.contains((Object)signedJWT.getHeader().getAlgorithm())) {
            throw new IllegalArgumentException("The client assertion JWT must be HMAC-signed (HS256, HS384 or HS512)");
        }
    }

    public static ClientSecretJWT parse(Map<String, String> map) throws ParseException {
        ClientSecretJWT clientSecretJWT;
        JWTAuthentication.ensureClientAssertionType(map);
        SignedJWT signedJWT = JWTAuthentication.parseClientAssertion(map);
        try {
            clientSecretJWT = new ClientSecretJWT(signedJWT);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException(illegalArgumentException.getMessage(), (Throwable)illegalArgumentException);
        }
        ClientID clientID = JWTAuthentication.parseClientID(map);
        if (clientID != null && !clientID.equals((Object)clientSecretJWT.getClientID())) {
            throw new ParseException("Invalid client secret JWT authentication: The client identifier doesn't match the client assertion subject / issuer");
        }
        return clientSecretJWT;
    }

    public static ClientSecretJWT parse(String string) throws ParseException {
        Map map = URLUtils.parseParameters((String)string);
        return ClientSecretJWT.parse((Map)map);
    }

    public static ClientSecretJWT parse(HTTPRequest hTTPRequest) throws ParseException {
        hTTPRequest.ensureMethod(HTTPRequest.Method.POST);
        hTTPRequest.ensureContentType(CommonContentTypes.APPLICATION_URLENCODED);
        return ClientSecretJWT.parse((Map)hTTPRequest.getQueryParameters());
    }

    public static /* bridge */ /* synthetic */ JWTAuthentication parse(HTTPRequest hTTPRequest) throws ParseException {
        return ClientSecretJWT.parse((HTTPRequest)hTTPRequest);
    }
}

