/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.assertions.saml2;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.PublicKey;
import javax.crypto.SecretKey;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ParseException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.assertions.saml2.BadSAML2AssertionException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.assertions.saml2.SAML2AssertionDetails;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.assertions.saml2.SAML2AssertionDetailsVerifier;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.id.Issuer;
import net.jcip.annotations.ThreadSafe;
import org.opensaml.DefaultBootstrap;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.security.SAMLSignatureProfileValidator;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.ConfigurationException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallerFactory;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.security.credential.BasicCredential;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.SignatureValidator;
import org.opensaml.xml.validation.ValidationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
@ThreadSafe
public class SAML2AssertionValidator {
    private final SAML2AssertionDetailsVerifier detailsVerifier;

    static {
        try {
            DefaultBootstrap.bootstrap();
        }
        catch (ConfigurationException configurationException) {
            throw new RuntimeException(configurationException.getMessage(), configurationException);
        }
    }

    public SAML2AssertionValidator(SAML2AssertionDetailsVerifier sAML2AssertionDetailsVerifier) {
        if (sAML2AssertionDetailsVerifier == null) {
            throw new IllegalArgumentException("The SAML 2.0 assertion details verifier must not be null");
        }
        this.detailsVerifier = sAML2AssertionDetailsVerifier;
    }

    public SAML2AssertionDetailsVerifier getDetailsVerifier() {
        return this.detailsVerifier;
    }

    public static Assertion parse(String string) throws ParseException {
        XMLObject xMLObject;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(new ByteArrayInputStream(string.getBytes("utf-8"))));
            Element element = document.getDocumentElement();
            UnmarshallerFactory unmarshallerFactory = Configuration.getUnmarshallerFactory();
            Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(element);
            xMLObject = unmarshaller.unmarshall(element);
        }
        catch (IOException | ParserConfigurationException | UnmarshallingException | SAXException throwable) {
            throw new ParseException("SAML 2.0 assertion parsing failed: " + throwable.getMessage(), throwable);
        }
        if (!(xMLObject instanceof Assertion)) {
            throw new ParseException("Top-level XML element not a SAML 2.0 assertion");
        }
        return (Assertion)xMLObject;
    }

    public static void verifySignature(Signature signature, Key key) throws BadSAML2AssertionException {
        SAMLSignatureProfileValidator sAMLSignatureProfileValidator = new SAMLSignatureProfileValidator();
        try {
            sAMLSignatureProfileValidator.validate(signature);
        }
        catch (ValidationException validationException) {
            throw new BadSAML2AssertionException("Invalid SAML 2.0 signature format: " + validationException.getMessage(), (Throwable)validationException);
        }
        BasicCredential basicCredential = new BasicCredential();
        if (key instanceof SecretKey) {
            basicCredential.setSecretKey((SecretKey)key);
        } else if (key instanceof PublicKey) {
            basicCredential.setPublicKey((PublicKey)key);
            basicCredential.setUsageType(UsageType.SIGNING);
        } else {
            throw new BadSAML2AssertionException("Unsupported key type: " + key.getAlgorithm());
        }
        SignatureValidator signatureValidator = new SignatureValidator((Credential)basicCredential);
        try {
            signatureValidator.validate(signature);
        }
        catch (ValidationException validationException) {
            throw new BadSAML2AssertionException("Bad SAML 2.0 signature: " + validationException.getMessage(), (Throwable)validationException);
        }
    }

    public Assertion validate(Assertion assertion, Issuer issuer, Key key) throws BadSAML2AssertionException {
        SAML2AssertionDetails sAML2AssertionDetails;
        try {
            sAML2AssertionDetails = SAML2AssertionDetails.parse((Assertion)assertion);
        }
        catch (ParseException parseException) {
            throw new BadSAML2AssertionException("Invalid SAML 2.0 assertion: " + parseException.getMessage(), (Throwable)parseException);
        }
        this.detailsVerifier.verify(sAML2AssertionDetails);
        if (!issuer.equals((Object)sAML2AssertionDetails.getIssuer())) {
            throw new BadSAML2AssertionException("Unexpected issuer: " + sAML2AssertionDetails.getIssuer());
        }
        if (!assertion.isSigned()) {
            throw new BadSAML2AssertionException("Missing XML signature");
        }
        SAML2AssertionValidator.verifySignature((Signature)assertion.getSignature(), (Key)key);
        return assertion;
    }

    public Assertion validate(String string, Issuer issuer, Key key) throws BadSAML2AssertionException {
        Assertion assertion;
        try {
            assertion = SAML2AssertionValidator.parse((String)string);
        }
        catch (ParseException parseException) {
            throw new BadSAML2AssertionException("Invalid SAML 2.0 assertion: " + parseException.getMessage(), (Throwable)parseException);
        }
        return this.validate(assertion, issuer, key);
    }
}

