/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.assertions.jwt;

import java.security.PrivateKey;
import java.security.Provider;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSAlgorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSHeader;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSSigner;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.ECDSASigner;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.MACSigner;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.RSASSASigner;
import macromedia.externals.com.nimbusds.jwt_8_2_1.SignedJWT;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.assertions.jwt.JWTAssertionDetails;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth.Secret;

public class JWTAssertionFactory {
    public static Set<JWSAlgorithm> supportedJWAs() {
        HashSet hashSet = new HashSet();
        hashSet.addAll(JWSAlgorithm.Family.HMAC_SHA);
        hashSet.addAll(JWSAlgorithm.Family.RSA);
        hashSet.addAll(JWSAlgorithm.Family.EC);
        return Collections.unmodifiableSet(hashSet);
    }

    public static SignedJWT create(JWTAssertionDetails jWTAssertionDetails, JWSAlgorithm jWSAlgorithm, Secret secret) throws JOSEException {
        SignedJWT signedJWT = new SignedJWT(new JWSHeader(jWSAlgorithm), jWTAssertionDetails.toJWTClaimsSet());
        signedJWT.sign((JWSSigner)new MACSigner(secret.getValueBytes()));
        return signedJWT;
    }

    public static SignedJWT create(JWTAssertionDetails jWTAssertionDetails, JWSAlgorithm jWSAlgorithm, RSAPrivateKey rSAPrivateKey, String string, Provider provider) throws JOSEException {
        SignedJWT signedJWT = new SignedJWT(new JWSHeader.Builder(jWSAlgorithm).keyID(string).build(), jWTAssertionDetails.toJWTClaimsSet());
        RSASSASigner rSASSASigner = new RSASSASigner((PrivateKey)rSAPrivateKey);
        if (provider != null) {
            rSASSASigner.getJCAContext().setProvider(provider);
        }
        signedJWT.sign((JWSSigner)rSASSASigner);
        return signedJWT;
    }

    public static SignedJWT create(JWTAssertionDetails jWTAssertionDetails, JWSAlgorithm jWSAlgorithm, ECPrivateKey eCPrivateKey, String string, Provider provider) throws JOSEException {
        SignedJWT signedJWT = new SignedJWT(new JWSHeader.Builder(jWSAlgorithm).keyID(string).build(), jWTAssertionDetails.toJWTClaimsSet());
        ECDSASigner eCDSASigner = new ECDSASigner(eCPrivateKey);
        if (provider != null) {
            eCDSASigner.getJCAContext().setProvider(provider);
        }
        signedJWT.sign((JWSSigner)eCDSASigner);
        return signedJWT;
    }

    private JWTAssertionFactory() {
    }
}

