/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.assertions.jwt;

import java.util.Set;
import macromedia.externals.com.nimbusds.jwt_8_2_1.JWTClaimsSet;
import macromedia.externals.com.nimbusds.jwt_8_2_1.proc.BadJWTException;
import macromedia.externals.com.nimbusds.jwt_8_2_1.proc.DefaultJWTClaimsVerifier;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.id.Audience;
import net.jcip.annotations.Immutable;
import org.apache.commons.collections4.CollectionUtils;

@Immutable
public class JWTAssertionDetailsVerifier
extends DefaultJWTClaimsVerifier {
    private static final BadJWTException MISSING_EXP_CLAIM_EXCEPTION = new BadJWTException("Missing JWT expiration claim");
    private static final BadJWTException MISSING_AUD_CLAIM_EXCEPTION = new BadJWTException("Missing JWT audience claim");
    private static final BadJWTException MISSING_SUB_CLAIM_EXCEPTION = new BadJWTException("Missing JWT subject claim");
    private static final BadJWTException MISSING_ISS_CLAIM_EXCEPTION = new BadJWTException("Missing JWT issuer claim");
    private final Set<Audience> expectedAudience;
    private final BadJWTException unexpectedAudClaimException;

    public JWTAssertionDetailsVerifier(Set<Audience> set) {
        if (CollectionUtils.isEmpty(set)) {
            throw new IllegalArgumentException("The expected audience set must not be null or empty");
        }
        this.expectedAudience = set;
        this.unexpectedAudClaimException = new BadJWTException("Invalid JWT audience claim, expected " + set);
    }

    public Set<Audience> getExpectedAudience() {
        return this.expectedAudience;
    }

    public void verify(JWTClaimsSet jWTClaimsSet) throws BadJWTException {
        super.verify(jWTClaimsSet);
        if (jWTClaimsSet.getExpirationTime() == null) {
            throw MISSING_EXP_CLAIM_EXCEPTION;
        }
        if (jWTClaimsSet.getAudience() == null || jWTClaimsSet.getAudience().isEmpty()) {
            throw MISSING_AUD_CLAIM_EXCEPTION;
        }
        boolean bl2 = false;
        for (String string : jWTClaimsSet.getAudience()) {
            if (string == null || string.isEmpty() || !this.expectedAudience.contains(new Audience(string))) continue;
            bl2 = true;
        }
        if (!bl2) {
            throw this.unexpectedAudClaimException;
        }
        if (jWTClaimsSet.getIssuer() == null) {
            throw MISSING_ISS_CLAIM_EXCEPTION;
        }
        if (jWTClaimsSet.getSubject() == null) {
            throw MISSING_SUB_CLAIM_EXCEPTION;
        }
    }
}

