/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.AbstractOptionallyAuthenticatedRequest;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ParseException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.SerializeException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.TokenIntrospectionRequest;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth.ClientAuthentication;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.CommonContentTypes;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.HTTPRequest;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.token.AccessToken;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.token.RefreshToken;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.token.Token;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.token.TypelessAccessToken;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.util.URLUtils;
import net.jcip.annotations.Immutable;

@Immutable
public class TokenIntrospectionRequest
extends AbstractOptionallyAuthenticatedRequest {
    private final Token token;
    private final AccessToken clientAuthz;
    private final Map<String, String> customParams;

    public TokenIntrospectionRequest(URI uRI, Token token) {
        this(uRI, token, null);
    }

    public TokenIntrospectionRequest(URI uRI, Token token, Map<String, String> map) {
        super(uRI, null);
        if (token == null) {
            throw new IllegalArgumentException("The token must not be null");
        }
        this.token = token;
        this.clientAuthz = null;
        this.customParams = map != null ? map : Collections.emptyMap();
    }

    public TokenIntrospectionRequest(URI uRI, ClientAuthentication clientAuthentication, Token token) {
        this(uRI, clientAuthentication, token, null);
    }

    public TokenIntrospectionRequest(URI uRI, ClientAuthentication clientAuthentication, Token token, Map<String, String> map) {
        super(uRI, clientAuthentication);
        if (token == null) {
            throw new IllegalArgumentException("The token must not be null");
        }
        this.token = token;
        this.clientAuthz = null;
        this.customParams = map != null ? map : Collections.emptyMap();
    }

    public TokenIntrospectionRequest(URI uRI, AccessToken accessToken, Token token) {
        this(uRI, accessToken, token, null);
    }

    public TokenIntrospectionRequest(URI uRI, AccessToken accessToken, Token token, Map<String, String> map) {
        super(uRI, null);
        if (token == null) {
            throw new IllegalArgumentException("The token must not be null");
        }
        this.token = token;
        this.clientAuthz = accessToken;
        this.customParams = map != null ? map : Collections.emptyMap();
    }

    public AccessToken getClientAuthorization() {
        return this.clientAuthz;
    }

    public Token getToken() {
        return this.token;
    }

    public Map<String, String> getCustomParameters() {
        return this.customParams;
    }

    public HTTPRequest toHTTPRequest() {
        URL uRL;
        if (this.getEndpointURI() == null) {
            throw new SerializeException("The endpoint URI is not specified");
        }
        try {
            uRL = this.getEndpointURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new SerializeException(malformedURLException.getMessage(), (Throwable)malformedURLException);
        }
        HTTPRequest hTTPRequest = new HTTPRequest(HTTPRequest.Method.POST, uRL);
        hTTPRequest.setContentType(CommonContentTypes.APPLICATION_URLENCODED);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("token", this.token.getValue());
        if (this.token instanceof AccessToken) {
            hashMap.put("token_type_hint", "access_token");
        } else if (this.token instanceof RefreshToken) {
            hashMap.put("token_type_hint", "refresh_token");
        }
        hashMap.putAll(this.customParams);
        hTTPRequest.setQuery(URLUtils.serializeParameters(hashMap));
        if (this.getClientAuthentication() != null) {
            this.getClientAuthentication().applyTo(hTTPRequest);
        }
        if (this.clientAuthz != null) {
            hTTPRequest.setAuthorization(this.clientAuthz.toAuthorizationHeader());
        }
        return hTTPRequest;
    }

    public static TokenIntrospectionRequest parse(HTTPRequest hTTPRequest) throws ParseException {
        URI uRI;
        hTTPRequest.ensureMethod(HTTPRequest.Method.POST);
        hTTPRequest.ensureContentType(CommonContentTypes.APPLICATION_URLENCODED);
        Map map = hTTPRequest.getQueryParameters();
        String string = (String)map.remove("token");
        if (string == null || string.isEmpty()) {
            throw new ParseException("Missing required token parameter");
        }
        1 var3_3 = null;
        String string2 = (String)map.remove("token_type_hint");
        if (string2 == null) {
            var3_3 = new /* Unavailable Anonymous Inner Class!! */;
        } else if (string2.equals("access_token")) {
            var3_3 = new TypelessAccessToken(string);
        } else if (string2.equals("refresh_token")) {
            var3_3 = new RefreshToken(string);
        }
        ClientAuthentication clientAuthentication = ClientAuthentication.parse((HTTPRequest)hTTPRequest);
        AccessToken accessToken = null;
        if (clientAuthentication == null && hTTPRequest.getAuthorization() != null) {
            accessToken = AccessToken.parse((String)hTTPRequest.getAuthorization());
        }
        try {
            uRI = hTTPRequest.getURL().toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ParseException(uRISyntaxException.getMessage(), (Throwable)uRISyntaxException);
        }
        if (accessToken != null) {
            return new TokenIntrospectionRequest(uRI, accessToken, (Token)var3_3, map);
        }
        return new TokenIntrospectionRequest(uRI, clientAuthentication, (Token)var3_3, map);
    }
}

