/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ErrorObject;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ErrorResponse;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.OAuth2Error;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ParseException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.TokenResponse;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.CommonContentTypes;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.HTTPResponse;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.util.JSONObjectUtils;
import macromedia.externals.net.minidev.json_1_3_1.JSONObject;
import net.jcip.annotations.Immutable;

/*
 * Exception performing whole class analysis ignored.
 */
@Immutable
public class TokenErrorResponse
extends TokenResponse
implements ErrorResponse {
    private static final Set<ErrorObject> STANDARD_ERRORS;
    private final ErrorObject error;

    static {
        HashSet<ErrorObject> hashSet = new HashSet<ErrorObject>();
        hashSet.add(OAuth2Error.INVALID_REQUEST);
        hashSet.add(OAuth2Error.INVALID_CLIENT);
        hashSet.add(OAuth2Error.INVALID_GRANT);
        hashSet.add(OAuth2Error.UNAUTHORIZED_CLIENT);
        hashSet.add(OAuth2Error.UNSUPPORTED_GRANT_TYPE);
        hashSet.add(OAuth2Error.INVALID_SCOPE);
        STANDARD_ERRORS = Collections.unmodifiableSet(hashSet);
    }

    public static Set<ErrorObject> getStandardErrors() {
        return STANDARD_ERRORS;
    }

    protected TokenErrorResponse() {
        this.error = null;
    }

    public TokenErrorResponse(ErrorObject errorObject) {
        if (errorObject == null) {
            throw new IllegalArgumentException("The error must not be null");
        }
        this.error = errorObject;
    }

    public boolean indicatesSuccess() {
        return false;
    }

    public ErrorObject getErrorObject() {
        return this.error;
    }

    public JSONObject toJSONObject() {
        JSONObject jSONObject = new JSONObject();
        if (this.error == null) {
            return jSONObject;
        }
        jSONObject.put((Object)"error", (Object)this.error.getCode());
        if (this.error.getDescription() != null) {
            jSONObject.put((Object)"error_description", (Object)this.error.getDescription());
        }
        if (this.error.getURI() != null) {
            jSONObject.put((Object)"error_uri", (Object)this.error.getURI().toString());
        }
        return jSONObject;
    }

    public HTTPResponse toHTTPResponse() {
        int n2 = this.error != null && this.error.getHTTPStatusCode() > 0 ? this.error.getHTTPStatusCode() : 400;
        HTTPResponse hTTPResponse = new HTTPResponse(n2);
        if (this.error == null) {
            return hTTPResponse;
        }
        hTTPResponse.setContentType(CommonContentTypes.APPLICATION_JSON);
        hTTPResponse.setCacheControl("no-store");
        hTTPResponse.setPragma("no-cache");
        hTTPResponse.setContent(this.toJSONObject().toString());
        return hTTPResponse;
    }

    public static TokenErrorResponse parse(JSONObject jSONObject) throws ParseException {
        ErrorObject errorObject;
        if (!jSONObject.containsKey((Object)"error")) {
            return new TokenErrorResponse();
        }
        try {
            String string = JSONObjectUtils.getString((JSONObject)jSONObject, (String)"error");
            String string2 = null;
            if (jSONObject.containsKey((Object)"error_description")) {
                string2 = JSONObjectUtils.getString((JSONObject)jSONObject, (String)"error_description");
            }
            URI uRI = null;
            if (jSONObject.containsKey((Object)"error_uri")) {
                uRI = new URI(JSONObjectUtils.getString((JSONObject)jSONObject, (String)"error_uri"));
            }
            errorObject = new ErrorObject(string, string2, 400, uRI);
        }
        catch (ParseException parseException) {
            throw new ParseException("Missing or invalid token error response parameter: " + parseException.getMessage(), (Throwable)parseException);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ParseException("Invalid error URI: " + uRISyntaxException.getMessage(), (Throwable)uRISyntaxException);
        }
        return new TokenErrorResponse(errorObject);
    }

    public static TokenErrorResponse parse(HTTPResponse hTTPResponse) throws ParseException {
        hTTPResponse.ensureStatusCodeNotOK();
        return new TokenErrorResponse(ErrorObject.parse((HTTPResponse)hTTPResponse));
    }

    public static /* bridge */ /* synthetic */ TokenResponse parse(HTTPResponse hTTPResponse) throws ParseException {
        return TokenErrorResponse.parse((HTTPResponse)hTTPResponse);
    }

    public static /* bridge */ /* synthetic */ TokenResponse parse(JSONObject jSONObject) throws ParseException {
        return TokenErrorResponse.parse((JSONObject)jSONObject);
    }
}

