/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.AuthorizationCode;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.AuthorizationResponse;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ParseException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ResponseMode;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ResponseType;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.SuccessResponse;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.HTTPRequest;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.HTTPResponse;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.id.State;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.token.AccessToken;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.util.URIUtils;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.util.URLUtils;
import macromedia.externals.net.minidev.json_1_3_1.JSONObject;
import net.jcip.annotations.Immutable;

/*
 * Exception performing whole class analysis ignored.
 */
@Immutable
public class AuthorizationSuccessResponse
extends AuthorizationResponse
implements SuccessResponse {
    private final AuthorizationCode code;
    private final AccessToken accessToken;

    public AuthorizationSuccessResponse(URI uRI, AuthorizationCode authorizationCode, AccessToken accessToken, State state, ResponseMode responseMode) {
        super(uRI, state, responseMode);
        this.code = authorizationCode;
        this.accessToken = accessToken;
    }

    public boolean indicatesSuccess() {
        return true;
    }

    public ResponseType impliedResponseType() {
        ResponseType responseType = new ResponseType();
        if (this.code != null) {
            responseType.add((Object)ResponseType.Value.CODE);
        }
        if (this.accessToken != null) {
            responseType.add((Object)ResponseType.Value.TOKEN);
        }
        return responseType;
    }

    public ResponseMode impliedResponseMode() {
        if (this.getResponseMode() != null) {
            return this.getResponseMode();
        }
        if (this.accessToken != null) {
            return ResponseMode.FRAGMENT;
        }
        return ResponseMode.QUERY;
    }

    public AuthorizationCode getAuthorizationCode() {
        return this.code;
    }

    public AccessToken getAccessToken() {
        return this.accessToken;
    }

    public Map<String, String> toParameters() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.code != null) {
            hashMap.put("code", this.code.getValue());
        }
        if (this.accessToken != null) {
            for (Map.Entry entry : this.accessToken.toJSONObject().entrySet()) {
                hashMap.put((String)entry.getKey(), entry.getValue().toString());
            }
        }
        if (this.getState() != null) {
            hashMap.put("state", this.getState().getValue());
        }
        return hashMap;
    }

    public static AuthorizationSuccessResponse parse(URI uRI, Map<String, String> map) throws ParseException {
        JSONObject jSONObject;
        AuthorizationCode authorizationCode = null;
        if (map.get("code") != null) {
            authorizationCode = new AuthorizationCode(map.get("code"));
        }
        AccessToken accessToken = null;
        if (map.get("access_token") != null) {
            jSONObject = new JSONObject();
            jSONObject.putAll(map);
            accessToken = AccessToken.parse((JSONObject)jSONObject);
        }
        jSONObject = State.parse((String)map.get("state"));
        return new AuthorizationSuccessResponse(uRI, authorizationCode, accessToken, (State)jSONObject, null);
    }

    public static AuthorizationSuccessResponse parse(URI uRI) throws ParseException {
        Map map;
        if (uRI.getRawFragment() != null) {
            map = URLUtils.parseParameters((String)uRI.getRawFragment());
        } else if (uRI.getRawQuery() != null) {
            map = URLUtils.parseParameters((String)uRI.getRawQuery());
        } else {
            throw new ParseException("Missing URI fragment or query string");
        }
        return AuthorizationSuccessResponse.parse((URI)URIUtils.getBaseURI((URI)uRI), (Map)map);
    }

    public static AuthorizationSuccessResponse parse(HTTPResponse hTTPResponse) throws ParseException {
        URI uRI = hTTPResponse.getLocation();
        if (uRI == null) {
            throw new ParseException("Missing redirection URL / HTTP Location header");
        }
        return AuthorizationSuccessResponse.parse((URI)uRI);
    }

    public static AuthorizationSuccessResponse parse(HTTPRequest hTTPRequest) throws ParseException {
        URI uRI;
        try {
            uRI = hTTPRequest.getURL().toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ParseException(uRISyntaxException.getMessage(), (Throwable)uRISyntaxException);
        }
        if (hTTPRequest.getQuery() != null) {
            return AuthorizationSuccessResponse.parse((URI)uRI, (Map)URLUtils.parseParameters((String)hTTPRequest.getQuery()));
        }
        if (hTTPRequest.getFragment() != null) {
            return AuthorizationSuccessResponse.parse((URI)uRI, (Map)URLUtils.parseParameters((String)hTTPRequest.getFragment()));
        }
        throw new ParseException("Missing URI fragment, query string or post body");
    }

    public static /* bridge */ /* synthetic */ AuthorizationResponse parse(HTTPRequest hTTPRequest) throws ParseException {
        return AuthorizationSuccessResponse.parse((HTTPRequest)hTTPRequest);
    }

    public static /* bridge */ /* synthetic */ AuthorizationResponse parse(HTTPResponse hTTPResponse) throws ParseException {
        return AuthorizationSuccessResponse.parse((HTTPResponse)hTTPResponse);
    }

    public static /* bridge */ /* synthetic */ AuthorizationResponse parse(URI uRI) throws ParseException {
        return AuthorizationSuccessResponse.parse((URI)uRI);
    }

    public static /* bridge */ /* synthetic */ AuthorizationResponse parse(URI uRI, Map map) throws ParseException {
        return AuthorizationSuccessResponse.parse((URI)uRI, (Map)map);
    }
}

