/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1;

import java.util.Map;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.AuthorizationCodeGrant;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ClientCredentialsGrant;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.GrantType;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.JWTBearerGrant;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.OAuth2Error;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ParseException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.RefreshTokenGrant;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ResourceOwnerPasswordCredentialsGrant;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.SAML2BearerGrant;

public abstract class AuthorizationGrant {
    private final GrantType type;

    protected AuthorizationGrant(GrantType grantType) {
        if (grantType == null) {
            throw new IllegalArgumentException("The grant type must not be null");
        }
        this.type = grantType;
    }

    public GrantType getType() {
        return this.type;
    }

    public abstract Map<String, String> toParameters();

    public static AuthorizationGrant parse(Map<String, String> map) throws ParseException {
        String string = map.get("grant_type");
        if (string == null) {
            throw new ParseException("Missing \"grant_type\" parameter", OAuth2Error.INVALID_REQUEST);
        }
        GrantType grantType = GrantType.parse((String)string);
        if (grantType.equals((Object)GrantType.AUTHORIZATION_CODE)) {
            return AuthorizationCodeGrant.parse(map);
        }
        if (grantType.equals((Object)GrantType.REFRESH_TOKEN)) {
            return RefreshTokenGrant.parse(map);
        }
        if (grantType.equals((Object)GrantType.PASSWORD)) {
            return ResourceOwnerPasswordCredentialsGrant.parse(map);
        }
        if (grantType.equals((Object)GrantType.CLIENT_CREDENTIALS)) {
            return ClientCredentialsGrant.parse(map);
        }
        if (grantType.equals((Object)GrantType.JWT_BEARER)) {
            return JWTBearerGrant.parse(map);
        }
        if (grantType.equals((Object)GrantType.SAML2_BEARER)) {
            return SAML2BearerGrant.parse(map);
        }
        throw new ParseException("Invalid or unsupported grant type: " + grantType, OAuth2Error.UNSUPPORTED_GRANT_TYPE);
    }
}

