/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.AuthorizationResponse;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ErrorObject;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ErrorResponse;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.OAuth2Error;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ParseException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ResponseMode;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.HTTPRequest;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.HTTPResponse;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.id.State;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.util.URIUtils;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.util.URLUtils;
import macromedia.externals.org.apache.commons_3_5.lang3.StringUtils;
import net.jcip.annotations.Immutable;

/*
 * Exception performing whole class analysis ignored.
 */
@Immutable
public class AuthorizationErrorResponse
extends AuthorizationResponse
implements ErrorResponse {
    private static final Set<ErrorObject> stdErrors = new HashSet();
    private final ErrorObject error;

    static {
        stdErrors.add(OAuth2Error.INVALID_REQUEST);
        stdErrors.add(OAuth2Error.UNAUTHORIZED_CLIENT);
        stdErrors.add(OAuth2Error.ACCESS_DENIED);
        stdErrors.add(OAuth2Error.UNSUPPORTED_RESPONSE_TYPE);
        stdErrors.add(OAuth2Error.INVALID_SCOPE);
        stdErrors.add(OAuth2Error.SERVER_ERROR);
        stdErrors.add(OAuth2Error.TEMPORARILY_UNAVAILABLE);
    }

    public static Set<ErrorObject> getStandardErrors() {
        return Collections.unmodifiableSet(stdErrors);
    }

    public AuthorizationErrorResponse(URI uRI, ErrorObject errorObject, State state, ResponseMode responseMode) {
        super(uRI, state, responseMode);
        if (errorObject == null) {
            throw new IllegalArgumentException("The error must not be null");
        }
        this.error = errorObject;
    }

    public boolean indicatesSuccess() {
        return false;
    }

    public ErrorObject getErrorObject() {
        return this.error;
    }

    public ResponseMode impliedResponseMode() {
        return this.getResponseMode() != null ? this.getResponseMode() : ResponseMode.QUERY;
    }

    public Map<String, String> toParameters() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("error", this.error.getCode());
        if (this.error.getDescription() != null) {
            hashMap.put("error_description", this.error.getDescription());
        }
        if (this.error.getURI() != null) {
            hashMap.put("error_uri", this.error.getURI().toString());
        }
        if (this.getState() != null) {
            hashMap.put("state", this.getState().getValue());
        }
        return hashMap;
    }

    public static AuthorizationErrorResponse parse(URI uRI, Map<String, String> map) throws ParseException {
        if (StringUtils.isBlank((CharSequence)map.get("error"))) {
            throw new ParseException("Missing error code");
        }
        String string = map.get("error");
        String string2 = map.get("error_description");
        String string3 = map.get("error_uri");
        URI uRI2 = null;
        if (string3 != null) {
            try {
                uRI2 = new URI(string3);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new ParseException("Invalid error URI: " + string3, (Throwable)uRISyntaxException);
            }
        }
        ErrorObject errorObject = new ErrorObject(string, string2, 302, uRI2);
        State state = State.parse((String)map.get("state"));
        return new AuthorizationErrorResponse(uRI, errorObject, state, null);
    }

    public static AuthorizationErrorResponse parse(URI uRI) throws ParseException {
        Map map;
        if (uRI.getRawFragment() != null) {
            map = URLUtils.parseParameters((String)uRI.getRawFragment());
        } else if (uRI.getRawQuery() != null) {
            map = URLUtils.parseParameters((String)uRI.getRawQuery());
        } else {
            throw new ParseException("Missing URI fragment or query string");
        }
        return AuthorizationErrorResponse.parse((URI)URIUtils.getBaseURI((URI)uRI), (Map)map);
    }

    public static AuthorizationErrorResponse parse(HTTPResponse hTTPResponse) throws ParseException {
        URI uRI = hTTPResponse.getLocation();
        if (uRI == null) {
            throw new ParseException("Missing redirection URL / HTTP Location header");
        }
        return AuthorizationErrorResponse.parse((URI)uRI);
    }

    public static AuthorizationErrorResponse parse(HTTPRequest hTTPRequest) throws ParseException {
        URI uRI;
        try {
            uRI = hTTPRequest.getURL().toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ParseException(uRISyntaxException.getMessage(), (Throwable)uRISyntaxException);
        }
        if (hTTPRequest.getQuery() != null) {
            return AuthorizationErrorResponse.parse((URI)uRI, (Map)URLUtils.parseParameters((String)hTTPRequest.getQuery()));
        }
        if (hTTPRequest.getFragment() != null) {
            return AuthorizationErrorResponse.parse((URI)uRI, (Map)URLUtils.parseParameters((String)hTTPRequest.getFragment()));
        }
        throw new ParseException("Missing URI fragment, query string or post body");
    }

    public static /* bridge */ /* synthetic */ AuthorizationResponse parse(HTTPRequest hTTPRequest) throws ParseException {
        return AuthorizationErrorResponse.parse((HTTPRequest)hTTPRequest);
    }

    public static /* bridge */ /* synthetic */ AuthorizationResponse parse(HTTPResponse hTTPResponse) throws ParseException {
        return AuthorizationErrorResponse.parse((HTTPResponse)hTTPResponse);
    }

    public static /* bridge */ /* synthetic */ AuthorizationResponse parse(URI uRI) throws ParseException {
        return AuthorizationErrorResponse.parse((URI)uRI);
    }

    public static /* bridge */ /* synthetic */ AuthorizationResponse parse(URI uRI, Map map) throws ParseException {
        return AuthorizationErrorResponse.parse((URI)uRI, (Map)map);
    }
}

