/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import java.util.Map;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.AuthorizationCode;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.AuthorizationGrant;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.GrantType;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.OAuth2Error;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ParseException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.pkce.CodeVerifier;
import macromedia.externals.org.apache.commons_3_5.lang3.StringUtils;
import net.jcip.annotations.Immutable;

/*
 * Exception performing whole class analysis ignored.
 */
@Immutable
public class AuthorizationCodeGrant
extends AuthorizationGrant {
    public static final GrantType GRANT_TYPE = GrantType.AUTHORIZATION_CODE;
    private final AuthorizationCode code;
    private final URI redirectURI;
    private final CodeVerifier codeVerifier;

    public AuthorizationCodeGrant(AuthorizationCode authorizationCode, URI uRI) {
        this(authorizationCode, uRI, null);
    }

    public AuthorizationCodeGrant(AuthorizationCode authorizationCode, URI uRI, CodeVerifier codeVerifier) {
        super(GRANT_TYPE);
        if (authorizationCode == null) {
            throw new IllegalArgumentException("The authorisation code must not be null");
        }
        this.code = authorizationCode;
        this.redirectURI = uRI;
        this.codeVerifier = codeVerifier;
    }

    public AuthorizationCode getAuthorizationCode() {
        return this.code;
    }

    public URI getRedirectionURI() {
        return this.redirectURI;
    }

    public CodeVerifier getCodeVerifier() {
        return this.codeVerifier;
    }

    public Map<String, String> toParameters() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("grant_type", GRANT_TYPE.getValue());
        linkedHashMap.put("code", this.code.getValue());
        if (this.redirectURI != null) {
            linkedHashMap.put("redirect_uri", this.redirectURI.toString());
        }
        if (this.codeVerifier != null) {
            linkedHashMap.put("code_verifier", this.codeVerifier.getValue());
        }
        return linkedHashMap;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AuthorizationCodeGrant)) {
            return false;
        }
        AuthorizationCodeGrant authorizationCodeGrant = (AuthorizationCodeGrant)object;
        if (!this.code.equals((Object)authorizationCodeGrant.code)) {
            return false;
        }
        if (this.redirectURI != null ? !this.redirectURI.equals(authorizationCodeGrant.redirectURI) : authorizationCodeGrant.redirectURI != null) {
            return false;
        }
        return this.codeVerifier != null ? this.codeVerifier.equals((Object)authorizationCodeGrant.codeVerifier) : authorizationCodeGrant.codeVerifier == null;
    }

    public int hashCode() {
        int n2 = this.code.hashCode();
        n2 = 31 * n2 + (this.redirectURI != null ? this.redirectURI.hashCode() : 0);
        n2 = 31 * n2 + (this.codeVerifier != null ? this.codeVerifier.hashCode() : 0);
        return n2;
    }

    public static AuthorizationCodeGrant parse(Map<String, String> map) throws ParseException {
        String string = map.get("grant_type");
        if (string == null) {
            String string2 = "Missing \"grant_type\" parameter";
            throw new ParseException(string2, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string2));
        }
        if (!GrantType.parse((String)string).equals((Object)GRANT_TYPE)) {
            String string3 = "The \"grant_type\" must be \"" + GRANT_TYPE + "\"";
            throw new ParseException(string3, OAuth2Error.UNSUPPORTED_GRANT_TYPE.appendDescription(": " + string3));
        }
        String string4 = map.get("code");
        if (string4 == null || string4.trim().isEmpty()) {
            String string5 = "Missing or empty \"code\" parameter";
            throw new ParseException(string5, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string5));
        }
        AuthorizationCode authorizationCode = new AuthorizationCode(string4);
        String string6 = map.get("redirect_uri");
        URI uRI = null;
        if (string6 != null) {
            try {
                uRI = new URI(string6);
            }
            catch (URISyntaxException uRISyntaxException) {
                String string7 = "Invalid \"redirect_uri\" parameter: " + uRISyntaxException.getMessage();
                throw new ParseException(string7, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string7), (Throwable)uRISyntaxException);
            }
        }
        String string8 = map.get("code_verifier");
        CodeVerifier codeVerifier = null;
        if (StringUtils.isNotBlank((CharSequence)string8)) {
            try {
                codeVerifier = new CodeVerifier(string8);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ParseException(illegalArgumentException.getMessage(), (Throwable)illegalArgumentException);
            }
        }
        return new AuthorizationCodeGrant(authorizationCode, uRI, codeVerifier);
    }

    public static /* bridge */ /* synthetic */ AuthorizationGrant parse(Map map) throws ParseException {
        return AuthorizationCodeGrant.parse((Map)map);
    }
}

