/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jwt_8_2_1.proc;

import java.security.Key;
import java.text.ParseException;
import java.util.List;
import java.util.ListIterator;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEDecrypter;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSHeader;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSVerifier;
import macromedia.externals.com.nimbusds.jose_8_2_1.KeySourceException;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.factories.DefaultJWEDecrypterFactory;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.factories.DefaultJWSVerifierFactory;
import macromedia.externals.com.nimbusds.jose_8_2_1.proc.BadJOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.proc.BadJWEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.proc.BadJWSException;
import macromedia.externals.com.nimbusds.jose_8_2_1.proc.DefaultJOSEObjectTypeVerifier;
import macromedia.externals.com.nimbusds.jose_8_2_1.proc.JOSEObjectTypeVerifier;
import macromedia.externals.com.nimbusds.jose_8_2_1.proc.JWEDecrypterFactory;
import macromedia.externals.com.nimbusds.jose_8_2_1.proc.JWEKeySelector;
import macromedia.externals.com.nimbusds.jose_8_2_1.proc.JWSKeySelector;
import macromedia.externals.com.nimbusds.jose_8_2_1.proc.JWSVerifierFactory;
import macromedia.externals.com.nimbusds.jose_8_2_1.proc.SecurityContext;
import macromedia.externals.com.nimbusds.jwt_8_2_1.EncryptedJWT;
import macromedia.externals.com.nimbusds.jwt_8_2_1.JWT;
import macromedia.externals.com.nimbusds.jwt_8_2_1.JWTClaimsSet;
import macromedia.externals.com.nimbusds.jwt_8_2_1.JWTParser;
import macromedia.externals.com.nimbusds.jwt_8_2_1.PlainJWT;
import macromedia.externals.com.nimbusds.jwt_8_2_1.SignedJWT;
import macromedia.externals.com.nimbusds.jwt_8_2_1.proc.BadJWTException;
import macromedia.externals.com.nimbusds.jwt_8_2_1.proc.ConfigurableJWTProcessor;
import macromedia.externals.com.nimbusds.jwt_8_2_1.proc.DefaultJWTClaimsVerifier;
import macromedia.externals.com.nimbusds.jwt_8_2_1.proc.JWTClaimsSetAwareJWSKeySelector;
import macromedia.externals.com.nimbusds.jwt_8_2_1.proc.JWTClaimsSetVerifier;
import macromedia.externals.com.nimbusds.jwt_8_2_1.proc.JWTClaimsVerifier;

public class DefaultJWTProcessor<C extends SecurityContext>
implements ConfigurableJWTProcessor<C> {
    private JOSEObjectTypeVerifier<C> jwsTypeVerifier = DefaultJOSEObjectTypeVerifier.JWT;
    private JOSEObjectTypeVerifier<C> jweTypeVerifier = DefaultJOSEObjectTypeVerifier.JWT;
    private JWSKeySelector<C> jwsKeySelector;
    private JWTClaimsSetAwareJWSKeySelector<C> claimsSetAwareJWSKeySelector;
    private JWEKeySelector<C> jweKeySelector;
    private JWSVerifierFactory jwsVerifierFactory = new DefaultJWSVerifierFactory();
    private JWEDecrypterFactory jweDecrypterFactory = new DefaultJWEDecrypterFactory();
    private JWTClaimsSetVerifier<C> claimsVerifier = new DefaultJWTClaimsVerifier();
    private JWTClaimsVerifier deprecatedClaimsVerifier = null;

    public JOSEObjectTypeVerifier<C> getJWSTypeVerifier() {
        return this.jwsTypeVerifier;
    }

    public void setJWSTypeVerifier(JOSEObjectTypeVerifier<C> jOSEObjectTypeVerifier) {
        this.jwsTypeVerifier = jOSEObjectTypeVerifier;
    }

    public JWSKeySelector<C> getJWSKeySelector() {
        return this.jwsKeySelector;
    }

    public void setJWSKeySelector(JWSKeySelector<C> jWSKeySelector) {
        this.jwsKeySelector = jWSKeySelector;
    }

    public JWTClaimsSetAwareJWSKeySelector<C> getJWTClaimsSetAwareJWSKeySelector() {
        return this.claimsSetAwareJWSKeySelector;
    }

    public void setJWTClaimsSetAwareJWSKeySelector(JWTClaimsSetAwareJWSKeySelector<C> jWTClaimsSetAwareJWSKeySelector) {
        this.claimsSetAwareJWSKeySelector = jWTClaimsSetAwareJWSKeySelector;
    }

    public JOSEObjectTypeVerifier<C> getJWETypeVerifier() {
        return this.jweTypeVerifier;
    }

    public void setJWETypeVerifier(JOSEObjectTypeVerifier<C> jOSEObjectTypeVerifier) {
        this.jweTypeVerifier = jOSEObjectTypeVerifier;
    }

    public JWEKeySelector<C> getJWEKeySelector() {
        return this.jweKeySelector;
    }

    public void setJWEKeySelector(JWEKeySelector<C> jWEKeySelector) {
        this.jweKeySelector = jWEKeySelector;
    }

    public JWSVerifierFactory getJWSVerifierFactory() {
        return this.jwsVerifierFactory;
    }

    public void setJWSVerifierFactory(JWSVerifierFactory jWSVerifierFactory) {
        this.jwsVerifierFactory = jWSVerifierFactory;
    }

    public JWEDecrypterFactory getJWEDecrypterFactory() {
        return this.jweDecrypterFactory;
    }

    public void setJWEDecrypterFactory(JWEDecrypterFactory jWEDecrypterFactory) {
        this.jweDecrypterFactory = jWEDecrypterFactory;
    }

    public JWTClaimsSetVerifier<C> getJWTClaimsSetVerifier() {
        return this.claimsVerifier;
    }

    public void setJWTClaimsSetVerifier(JWTClaimsSetVerifier<C> jWTClaimsSetVerifier) {
        this.claimsVerifier = jWTClaimsSetVerifier;
        this.deprecatedClaimsVerifier = null;
    }

    @Deprecated
    public JWTClaimsVerifier getJWTClaimsVerifier() {
        return this.deprecatedClaimsVerifier;
    }

    @Deprecated
    public void setJWTClaimsVerifier(JWTClaimsVerifier jWTClaimsVerifier) {
        this.claimsVerifier = null;
        this.deprecatedClaimsVerifier = jWTClaimsVerifier;
    }

    private JWTClaimsSet extractJWTClaimsSet(JWT jWT) throws BadJWTException {
        try {
            return jWT.getJWTClaimsSet();
        }
        catch (ParseException parseException) {
            throw new BadJWTException(parseException.getMessage(), (Throwable)parseException);
        }
    }

    private JWTClaimsSet verifyClaims(JWTClaimsSet jWTClaimsSet, C c2) throws BadJWTException {
        if (this.getJWTClaimsSetVerifier() != null) {
            this.getJWTClaimsSetVerifier().verify(jWTClaimsSet, c2);
        } else if (this.getJWTClaimsVerifier() != null) {
            this.getJWTClaimsVerifier().verify(jWTClaimsSet);
        }
        return jWTClaimsSet;
    }

    private List<? extends Key> selectKeys(JWSHeader jWSHeader, JWTClaimsSet jWTClaimsSet, C c2) throws KeySourceException, BadJOSEException {
        if (this.getJWTClaimsSetAwareJWSKeySelector() != null) {
            return this.getJWTClaimsSetAwareJWSKeySelector().selectKeys(jWSHeader, jWTClaimsSet, c2);
        }
        if (this.getJWSKeySelector() != null) {
            return this.getJWSKeySelector().selectJWSKeys(jWSHeader, c2);
        }
        throw new BadJOSEException("Signed JWT rejected: No JWS key selector is configured");
    }

    public JWTClaimsSet process(String string, C c2) throws ParseException, BadJOSEException, JOSEException {
        return this.process(JWTParser.parse((String)string), c2);
    }

    public JWTClaimsSet process(JWT jWT, C c2) throws BadJOSEException, JOSEException {
        if (jWT instanceof SignedJWT) {
            return this.process((SignedJWT)jWT, c2);
        }
        if (jWT instanceof EncryptedJWT) {
            return this.process((EncryptedJWT)jWT, c2);
        }
        if (jWT instanceof PlainJWT) {
            return this.process((PlainJWT)jWT, c2);
        }
        throw new JOSEException("Unexpected JWT object type: " + jWT.getClass());
    }

    public JWTClaimsSet process(PlainJWT plainJWT, C c2) throws BadJOSEException, JOSEException {
        if (this.jwsTypeVerifier == null) {
            throw new BadJOSEException("Plain JWT rejected: No JWS header \"typ\" (type) verifier is configured");
        }
        this.jwsTypeVerifier.verify(plainJWT.getHeader().getType(), c2);
        throw new BadJOSEException("Unsecured (plain) JWTs are rejected, extend class to handle");
    }

    public JWTClaimsSet process(SignedJWT signedJWT, C c2) throws BadJOSEException, JOSEException {
        if (this.jwsTypeVerifier == null) {
            throw new BadJOSEException("Signed JWT rejected: No JWS header \"typ\" (type) verifier is configured");
        }
        this.jwsTypeVerifier.verify(signedJWT.getHeader().getType(), c2);
        if (this.getJWSKeySelector() == null && this.getJWTClaimsSetAwareJWSKeySelector() == null) {
            throw new BadJOSEException("Signed JWT rejected: No JWS key selector is configured");
        }
        if (this.getJWSVerifierFactory() == null) {
            throw new JOSEException("No JWS verifier is configured");
        }
        JWTClaimsSet jWTClaimsSet = this.extractJWTClaimsSet((JWT)signedJWT);
        List list = this.selectKeys(signedJWT.getHeader(), jWTClaimsSet, c2);
        if (list == null || list.isEmpty()) {
            throw new BadJOSEException("Signed JWT rejected: Another algorithm expected, or no matching key(s) found");
        }
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            JWSVerifier jWSVerifier = this.getJWSVerifierFactory().createJWSVerifier(signedJWT.getHeader(), (Key)listIterator.next());
            if (jWSVerifier == null) continue;
            boolean bl2 = signedJWT.verify(jWSVerifier);
            if (bl2) {
                return this.verifyClaims(jWTClaimsSet, c2);
            }
            if (listIterator.hasNext()) continue;
            throw new BadJWSException("Signed JWT rejected: Invalid signature");
        }
        throw new BadJOSEException("JWS object rejected: No matching verifier(s) found");
    }

    public JWTClaimsSet process(EncryptedJWT encryptedJWT, C c2) throws BadJOSEException, JOSEException {
        if (this.jweTypeVerifier == null) {
            throw new BadJOSEException("Encrypted JWT rejected: No JWE header \"typ\" (type) verifier is configured");
        }
        this.jweTypeVerifier.verify(encryptedJWT.getHeader().getType(), c2);
        if (this.getJWEKeySelector() == null) {
            throw new BadJOSEException("Encrypted JWT rejected: No JWE key selector is configured");
        }
        if (this.getJWEDecrypterFactory() == null) {
            throw new JOSEException("No JWE decrypter is configured");
        }
        List list = this.getJWEKeySelector().selectJWEKeys(encryptedJWT.getHeader(), c2);
        if (list == null || list.isEmpty()) {
            throw new BadJOSEException("Encrypted JWT rejected: Another algorithm expected, or no matching key(s) found");
        }
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            JWEDecrypter jWEDecrypter = this.getJWEDecrypterFactory().createJWEDecrypter(encryptedJWT.getHeader(), (Key)listIterator.next());
            if (jWEDecrypter == null) continue;
            try {
                encryptedJWT.decrypt(jWEDecrypter);
            }
            catch (JOSEException jOSEException) {
                if (listIterator.hasNext()) continue;
                throw new BadJWEException("Encrypted JWT rejected: " + jOSEException.getMessage(), (Throwable)jOSEException);
            }
            if ("JWT".equalsIgnoreCase(encryptedJWT.getHeader().getContentType())) {
                SignedJWT signedJWT = encryptedJWT.getPayload().toSignedJWT();
                if (signedJWT == null) {
                    throw new BadJWTException("The payload is not a nested signed JWT");
                }
                return this.process(signedJWT, c2);
            }
            JWTClaimsSet jWTClaimsSet = this.extractJWTClaimsSet((JWT)encryptedJWT);
            return this.verifyClaims(jWTClaimsSet, c2);
        }
        throw new BadJOSEException("Encrypted JWT rejected: No matching decrypter(s) found");
    }
}

