/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jwt_8_2_1;

import java.text.ParseException;
import macromedia.externals.com.nimbusds.jose_8_2_1.Algorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.Header;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEAlgorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSAlgorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64URL;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.JSONObjectUtils;
import macromedia.externals.com.nimbusds.jwt_8_2_1.EncryptedJWT;
import macromedia.externals.com.nimbusds.jwt_8_2_1.JWT;
import macromedia.externals.com.nimbusds.jwt_8_2_1.PlainJWT;
import macromedia.externals.com.nimbusds.jwt_8_2_1.SignedJWT;
import macromedia.externals.net.minidev.json_1_3_1.JSONObject;

public final class JWTParser {
    public static JWT parse(String string) throws ParseException {
        JSONObject jSONObject;
        int n2 = string.indexOf(".");
        if (n2 == -1) {
            throw new ParseException("Invalid JWT serialization: Missing dot delimiter(s)", 0);
        }
        Base64URL base64URL = new Base64URL(string.substring(0, n2));
        try {
            jSONObject = JSONObjectUtils.parse((String)base64URL.decodeToString());
        }
        catch (ParseException parseException) {
            throw new ParseException("Invalid unsecured/JWS/JWE header: " + parseException.getMessage(), 0);
        }
        Algorithm algorithm = Header.parseAlgorithm((JSONObject)jSONObject);
        if (algorithm.equals((Object)Algorithm.NONE)) {
            return PlainJWT.parse((String)string);
        }
        if (algorithm instanceof JWSAlgorithm) {
            return SignedJWT.parse((String)string);
        }
        if (algorithm instanceof JWEAlgorithm) {
            return EncryptedJWT.parse((String)string);
        }
        throw new AssertionError((Object)("Unexpected algorithm type: " + algorithm));
    }

    private JWTParser() {
    }
}

