/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jwt_8_2_1;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.DateUtils;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.JSONObjectUtils;
import macromedia.externals.com.nimbusds.jwt_8_2_1.JWTClaimsSet;
import macromedia.externals.com.nimbusds.jwt_8_2_1.JWTClaimsSetTransformer;
import macromedia.externals.net.minidev.json_1_3_1.JSONArray;
import macromedia.externals.net.minidev.json_1_3_1.JSONObject;
import net.jcip.annotations.Immutable;

/*
 * Exception performing whole class analysis ignored.
 */
@Immutable
public final class JWTClaimsSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String ISSUER_CLAIM = "iss";
    private static final String SUBJECT_CLAIM = "sub";
    private static final String AUDIENCE_CLAIM = "aud";
    private static final String EXPIRATION_TIME_CLAIM = "exp";
    private static final String NOT_BEFORE_CLAIM = "nbf";
    private static final String ISSUED_AT_CLAIM = "iat";
    private static final String JWT_ID_CLAIM = "jti";
    private static final Set<String> REGISTERED_CLAIM_NAMES;
    private final Map<String, Object> claims = new LinkedHashMap();

    private JWTClaimsSet(Map<String, Object> map) {
        this.claims.putAll(map);
    }

    public static Set<String> getRegisteredNames() {
        return REGISTERED_CLAIM_NAMES;
    }

    public String getIssuer() {
        try {
            return this.getStringClaim("iss");
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public String getSubject() {
        try {
            return this.getStringClaim("sub");
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public List<String> getAudience() {
        List list;
        Object object = this.getClaim("aud");
        if (object instanceof String) {
            return Collections.singletonList((String)object);
        }
        try {
            list = this.getStringListClaim("aud");
        }
        catch (ParseException parseException) {
            return Collections.emptyList();
        }
        return list != null ? Collections.unmodifiableList(list) : Collections.emptyList();
    }

    public Date getExpirationTime() {
        try {
            return this.getDateClaim("exp");
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public Date getNotBeforeTime() {
        try {
            return this.getDateClaim("nbf");
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public Date getIssueTime() {
        try {
            return this.getDateClaim("iat");
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public String getJWTID() {
        try {
            return this.getStringClaim("jti");
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public Object getClaim(String string) {
        return this.claims.get(string);
    }

    public String getStringClaim(String string) throws ParseException {
        Object object = this.getClaim(string);
        if (object == null || object instanceof String) {
            return (String)object;
        }
        throw new ParseException("The \"" + string + "\" claim is not a String", 0);
    }

    public String[] getStringArrayClaim(String string) throws ParseException {
        List list;
        Object object = this.getClaim(string);
        if (object == null) {
            return null;
        }
        try {
            list = (List)this.getClaim(string);
        }
        catch (ClassCastException classCastException) {
            throw new ParseException("The \"" + string + "\" claim is not a list / JSON array", 0);
        }
        String[] stringArray = new String[list.size()];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            try {
                stringArray[i2] = (String)list.get(i2);
                continue;
            }
            catch (ClassCastException classCastException) {
                throw new ParseException("The \"" + string + "\" claim is not a list / JSON array of strings", 0);
            }
        }
        return stringArray;
    }

    public List<String> getStringListClaim(String string) throws ParseException {
        String[] stringArray = this.getStringArrayClaim(string);
        if (stringArray == null) {
            return null;
        }
        return Collections.unmodifiableList(Arrays.asList(stringArray));
    }

    public URI getURIClaim(String string) throws ParseException {
        String string2 = this.getStringClaim(string);
        if (string2 == null) {
            return null;
        }
        try {
            return new URI(string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ParseException("The \"" + string + "\" claim is not a URI: " + uRISyntaxException.getMessage(), 0);
        }
    }

    public Boolean getBooleanClaim(String string) throws ParseException {
        Object object = this.getClaim(string);
        if (object == null || object instanceof Boolean) {
            return (Boolean)object;
        }
        throw new ParseException("The \"" + string + "\" claim is not a Boolean", 0);
    }

    public Integer getIntegerClaim(String string) throws ParseException {
        Object object = this.getClaim(string);
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        throw new ParseException("The \"" + string + "\" claim is not an Integer", 0);
    }

    public Long getLongClaim(String string) throws ParseException {
        Object object = this.getClaim(string);
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        throw new ParseException("The \"" + string + "\" claim is not a Number", 0);
    }

    public Date getDateClaim(String string) throws ParseException {
        Object object = this.getClaim(string);
        if (object == null) {
            return null;
        }
        if (object instanceof Date) {
            return (Date)object;
        }
        if (object instanceof Number) {
            return DateUtils.fromSecondsSinceEpoch((long)((Number)object).longValue());
        }
        throw new ParseException("The \"" + string + "\" claim is not a Date", 0);
    }

    public Float getFloatClaim(String string) throws ParseException {
        Object object = this.getClaim(string);
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            return Float.valueOf(((Number)object).floatValue());
        }
        throw new ParseException("The \"" + string + "\" claim is not a Float", 0);
    }

    public Double getDoubleClaim(String string) throws ParseException {
        Object object = this.getClaim(string);
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        throw new ParseException("The \"" + string + "\" claim is not a Double", 0);
    }

    public JSONObject getJSONObjectClaim(String string) throws ParseException {
        Object object = this.getClaim(string);
        if (object == null) {
            return null;
        }
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        if (object instanceof Map) {
            JSONObject jSONObject = new JSONObject();
            Map map = (Map)object;
            for (Map.Entry entry : map.entrySet()) {
                if (!(entry.getKey() instanceof String)) continue;
                jSONObject.put((Object)((String)entry.getKey()), entry.getValue());
            }
            return jSONObject;
        }
        throw new ParseException("The \"" + string + "\" claim is not a JSON object or Map", 0);
    }

    public Map<String, Object> getClaims() {
        return Collections.unmodifiableMap(this.claims);
    }

    public JSONObject toJSONObject() {
        return this.toJSONObject(false);
    }

    public JSONObject toJSONObject(boolean bl2) {
        JSONObject jSONObject = new JSONObject();
        for (Map.Entry entry : this.claims.entrySet()) {
            Object object;
            if (entry.getValue() instanceof Date) {
                object = (Date)entry.getValue();
                jSONObject.put(entry.getKey(), (Object)DateUtils.toSecondsSinceEpoch((Date)object));
                continue;
            }
            if ("aud".equals(entry.getKey())) {
                object = this.getAudience();
                if (object != null && !object.isEmpty()) {
                    if (object.size() == 1) {
                        jSONObject.put((Object)"aud", object.get(0));
                        continue;
                    }
                    JSONArray jSONArray = new JSONArray();
                    jSONArray.addAll((Collection)object);
                    jSONObject.put((Object)"aud", (Object)jSONArray);
                    continue;
                }
                if (!bl2) continue;
                jSONObject.put((Object)"aud", null);
                continue;
            }
            if (entry.getValue() != null) {
                jSONObject.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (!bl2) continue;
            jSONObject.put(entry.getKey(), null);
        }
        return jSONObject;
    }

    public String toString() {
        return this.toJSONObject().toJSONString();
    }

    public <T> T toType(JWTClaimsSetTransformer<T> jWTClaimsSetTransformer) {
        return (T)jWTClaimsSetTransformer.transform(this);
    }

    public static JWTClaimsSet parse(JSONObject jSONObject) throws ParseException {
        Builder builder = new Builder();
        for (String string : jSONObject.keySet()) {
            if (string.equals("iss")) {
                builder.issuer(JSONObjectUtils.getString((JSONObject)jSONObject, (String)"iss"));
                continue;
            }
            if (string.equals("sub")) {
                builder.subject(JSONObjectUtils.getString((JSONObject)jSONObject, (String)"sub"));
                continue;
            }
            if (string.equals("aud")) {
                Object object = jSONObject.get((Object)"aud");
                if (object instanceof String) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(JSONObjectUtils.getString((JSONObject)jSONObject, (String)"aud"));
                    builder.audience(arrayList);
                    continue;
                }
                if (object instanceof List) {
                    builder.audience(JSONObjectUtils.getStringList((JSONObject)jSONObject, (String)"aud"));
                    continue;
                }
                if (object != null) continue;
                builder.audience((String)null);
                continue;
            }
            if (string.equals("exp")) {
                builder.expirationTime(new Date(JSONObjectUtils.getLong((JSONObject)jSONObject, (String)"exp") * 1000L));
                continue;
            }
            if (string.equals("nbf")) {
                builder.notBeforeTime(new Date(JSONObjectUtils.getLong((JSONObject)jSONObject, (String)"nbf") * 1000L));
                continue;
            }
            if (string.equals("iat")) {
                builder.issueTime(new Date(JSONObjectUtils.getLong((JSONObject)jSONObject, (String)"iat") * 1000L));
                continue;
            }
            if (string.equals("jti")) {
                builder.jwtID(JSONObjectUtils.getString((JSONObject)jSONObject, (String)"jti"));
                continue;
            }
            builder.claim(string, jSONObject.get((Object)string));
        }
        return builder.build();
    }

    public static JWTClaimsSet parse(String string) throws ParseException {
        return JWTClaimsSet.parse((JSONObject)JSONObjectUtils.parse((String)string));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof JWTClaimsSet)) {
            return false;
        }
        JWTClaimsSet jWTClaimsSet = (JWTClaimsSet)object;
        return Objects.equals(this.claims, jWTClaimsSet.claims);
    }

    public int hashCode() {
        return Objects.hash(this.claims);
    }

    static /* synthetic */ Map access$000(JWTClaimsSet jWTClaimsSet) {
        return jWTClaimsSet.claims;
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("iss");
        hashSet.add("sub");
        hashSet.add("aud");
        hashSet.add("exp");
        hashSet.add("nbf");
        hashSet.add("iat");
        hashSet.add("jti");
        REGISTERED_CLAIM_NAMES = Collections.unmodifiableSet(hashSet);
    }
}

