/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jwt_8_2_1;

import java.text.ParseException;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEObject;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEHeader;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEObject;
import macromedia.externals.com.nimbusds.jose_8_2_1.Payload;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64URL;
import macromedia.externals.com.nimbusds.jwt_8_2_1.JWT;
import macromedia.externals.com.nimbusds.jwt_8_2_1.JWTClaimsSet;
import macromedia.externals.net.minidev.json_1_3_1.JSONObject;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class EncryptedJWT
extends JWEObject
implements JWT {
    private static final long serialVersionUID = 1L;

    public EncryptedJWT(JWEHeader jWEHeader, JWTClaimsSet jWTClaimsSet) {
        super(jWEHeader, new Payload(jWTClaimsSet.toJSONObject()));
    }

    public EncryptedJWT(Base64URL base64URL, Base64URL base64URL2, Base64URL base64URL3, Base64URL base64URL4, Base64URL base64URL5) throws ParseException {
        super(base64URL, base64URL2, base64URL3, base64URL4, base64URL5);
    }

    public JWTClaimsSet getJWTClaimsSet() throws ParseException {
        Payload payload = this.getPayload();
        if (payload == null) {
            return null;
        }
        JSONObject jSONObject = payload.toJSONObject();
        if (jSONObject == null) {
            throw new ParseException("Payload of JWE object is not a valid JSON object", 0);
        }
        return JWTClaimsSet.parse((JSONObject)jSONObject);
    }

    public static EncryptedJWT parse(String string) throws ParseException {
        Base64URL[] base64URLArray = JOSEObject.split((String)string);
        if (base64URLArray.length != 5) {
            throw new ParseException("Unexpected number of Base64URL parts, must be five", 0);
        }
        return new EncryptedJWT(base64URLArray[0], base64URLArray[1], base64URLArray[2], base64URLArray[3], base64URLArray[4]);
    }
}

