/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.util;

import java.io.ByteArrayInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64URL;

/*
 * Exception performing whole class analysis ignored.
 */
public class X509CertUtils {
    private static final String PEM_BEGIN_MARKER = "-----BEGIN CERTIFICATE-----";
    private static final String PEM_END_MARKER = "-----END CERTIFICATE-----";

    public static X509Certificate parse(byte[] byArray) {
        try {
            return X509CertUtils.parseWithException((byte[])byArray);
        }
        catch (CertificateException certificateException) {
            return null;
        }
    }

    public static X509Certificate parseWithException(byte[] byArray) throws CertificateException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        Certificate certificate = certificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
        if (!(certificate instanceof X509Certificate)) {
            throw new CertificateException("Not a X.509 certificate: " + certificate.getType());
        }
        return (X509Certificate)certificate;
    }

    public static X509Certificate parse(String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        int n2 = string.indexOf("-----BEGIN CERTIFICATE-----");
        if (n2 < 0) {
            return null;
        }
        String string2 = string.substring(n2 + "-----BEGIN CERTIFICATE-----".length());
        int n3 = string2.indexOf("-----END CERTIFICATE-----");
        if (n3 < 0) {
            return null;
        }
        string2 = string2.substring(0, n3);
        string2 = string2.replaceAll("\\s", "");
        return X509CertUtils.parse((byte[])new Base64(string2).decode());
    }

    public static X509Certificate parseWithException(String string) throws CertificateException {
        if (string == null || string.isEmpty()) {
            return null;
        }
        int n2 = string.indexOf("-----BEGIN CERTIFICATE-----");
        if (n2 < 0) {
            throw new CertificateException("PEM begin marker not found");
        }
        String string2 = string.substring(n2 + "-----BEGIN CERTIFICATE-----".length());
        int n3 = string2.indexOf("-----END CERTIFICATE-----");
        if (n3 < 0) {
            throw new CertificateException("PEM end marker not found");
        }
        string2 = string2.substring(0, n3);
        string2 = string2.replaceAll("\\s", "");
        return X509CertUtils.parseWithException((byte[])new Base64(string2).decode());
    }

    public static String toPEMString(X509Certificate x509Certificate) {
        return X509CertUtils.toPEMString((X509Certificate)x509Certificate, (boolean)true);
    }

    public static String toPEMString(X509Certificate x509Certificate, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("-----BEGIN CERTIFICATE-----");
        if (bl2) {
            stringBuilder.append('\n');
        }
        try {
            stringBuilder.append(Base64.encode((byte[])x509Certificate.getEncoded()).toString());
        }
        catch (CertificateEncodingException certificateEncodingException) {
            return null;
        }
        if (bl2) {
            stringBuilder.append('\n');
        }
        stringBuilder.append("-----END CERTIFICATE-----");
        return stringBuilder.toString();
    }

    public static Base64URL computeSHA256Thumbprint(X509Certificate x509Certificate) {
        try {
            byte[] byArray = x509Certificate.getEncoded();
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            return Base64URL.encode((byte[])messageDigest.digest(byArray));
        }
        catch (NoSuchAlgorithmException | CertificateEncodingException generalSecurityException) {
            return null;
        }
    }
}

