/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.AbstractRestrictedResourceRetriever;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.BoundedInputStream;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.IOUtils;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Resource;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.RestrictedResourceRetriever;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DefaultResourceRetriever
extends AbstractRestrictedResourceRetriever
implements RestrictedResourceRetriever {
    private boolean disconnectAfterUse;
    private Proxy proxy;

    public DefaultResourceRetriever() {
        this(0, 0);
    }

    public DefaultResourceRetriever(int n2, int n3) {
        this(n2, n3, 0);
    }

    public DefaultResourceRetriever(int n2, int n3, int n4) {
        this(n2, n3, n4, true);
    }

    public DefaultResourceRetriever(int n2, int n3, int n4, boolean bl2) {
        super(n2, n3, n4);
        this.disconnectAfterUse = bl2;
    }

    public boolean disconnectsAfterUse() {
        return this.disconnectAfterUse;
    }

    public void setDisconnectsAfterUse(boolean bl2) {
        this.disconnectAfterUse = bl2;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public Resource retrieveResource(URL uRL) throws IOException {
        HttpURLConnection httpURLConnection = null;
        try {
            String string;
            httpURLConnection = this.openConnection(uRL);
            httpURLConnection.setConnectTimeout(this.getConnectTimeout());
            httpURLConnection.setReadTimeout(this.getReadTimeout());
            InputStream inputStream = this.getInputStream(httpURLConnection, this.getSizeLimit());
            Object object = null;
            try {
                string = IOUtils.readInputStreamToString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (inputStream != null) {
                    if (object != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
            int n2 = httpURLConnection.getResponseCode();
            object = httpURLConnection.getResponseMessage();
            if (n2 > 299 || n2 < 200) {
                throw new IOException("HTTP " + n2 + ": " + (String)object);
            }
            Resource resource = new Resource(string, httpURLConnection.getContentType());
            return resource;
        }
        catch (ClassCastException classCastException) {
            throw new IOException("Couldn't open HTTP(S) connection: " + classCastException.getMessage(), classCastException);
        }
        finally {
            if (this.disconnectAfterUse && httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    protected HttpURLConnection openConnection(URL uRL) throws IOException {
        if (this.proxy != null) {
            return (HttpURLConnection)uRL.openConnection(this.proxy);
        }
        return (HttpURLConnection)uRL.openConnection();
    }

    private InputStream getInputStream(HttpURLConnection httpURLConnection, int n2) throws IOException {
        InputStream inputStream = httpURLConnection.getInputStream();
        return n2 > 0 ? new BoundedInputStream(inputStream, (long)this.getSizeLimit()) : inputStream;
    }
}

