/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.proc;

import java.security.Key;
import java.text.ParseException;
import java.util.List;
import java.util.ListIterator;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEObject;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEDecrypter;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEObject;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSObject;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSVerifier;
import macromedia.externals.com.nimbusds.jose_8_2_1.Payload;
import macromedia.externals.com.nimbusds.jose_8_2_1.PlainObject;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.factories.DefaultJWEDecrypterFactory;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.factories.DefaultJWSVerifierFactory;
import macromedia.externals.com.nimbusds.jose_8_2_1.proc.BadJOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.proc.BadJWEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.proc.BadJWSException;
import macromedia.externals.com.nimbusds.jose_8_2_1.proc.ConfigurableJOSEProcessor;
import macromedia.externals.com.nimbusds.jose_8_2_1.proc.DefaultJOSEObjectTypeVerifier;
import macromedia.externals.com.nimbusds.jose_8_2_1.proc.JOSEObjectTypeVerifier;
import macromedia.externals.com.nimbusds.jose_8_2_1.proc.JWEDecrypterFactory;
import macromedia.externals.com.nimbusds.jose_8_2_1.proc.JWEKeySelector;
import macromedia.externals.com.nimbusds.jose_8_2_1.proc.JWSKeySelector;
import macromedia.externals.com.nimbusds.jose_8_2_1.proc.JWSVerifierFactory;
import macromedia.externals.com.nimbusds.jose_8_2_1.proc.SecurityContext;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DefaultJOSEProcessor<C extends SecurityContext>
implements ConfigurableJOSEProcessor<C> {
    private JOSEObjectTypeVerifier<C> jwsTypeVerifier = DefaultJOSEObjectTypeVerifier.JOSE;
    private JOSEObjectTypeVerifier<C> jweTypeVerifier = DefaultJOSEObjectTypeVerifier.JOSE;
    private JWSKeySelector<C> jwsKeySelector;
    private JWEKeySelector<C> jweKeySelector;
    private JWSVerifierFactory jwsVerifierFactory = new DefaultJWSVerifierFactory();
    private JWEDecrypterFactory jweDecrypterFactory = new DefaultJWEDecrypterFactory();

    public JOSEObjectTypeVerifier<C> getJWSTypeVerifier() {
        return this.jwsTypeVerifier;
    }

    public void setJWSTypeVerifier(JOSEObjectTypeVerifier<C> jOSEObjectTypeVerifier) {
        this.jwsTypeVerifier = jOSEObjectTypeVerifier;
    }

    public JWSKeySelector<C> getJWSKeySelector() {
        return this.jwsKeySelector;
    }

    public void setJWSKeySelector(JWSKeySelector<C> jWSKeySelector) {
        this.jwsKeySelector = jWSKeySelector;
    }

    public JOSEObjectTypeVerifier<C> getJWETypeVerifier() {
        return this.jweTypeVerifier;
    }

    public void setJWETypeVerifier(JOSEObjectTypeVerifier<C> jOSEObjectTypeVerifier) {
        this.jweTypeVerifier = jOSEObjectTypeVerifier;
    }

    public JWEKeySelector<C> getJWEKeySelector() {
        return this.jweKeySelector;
    }

    public void setJWEKeySelector(JWEKeySelector<C> jWEKeySelector) {
        this.jweKeySelector = jWEKeySelector;
    }

    public JWSVerifierFactory getJWSVerifierFactory() {
        return this.jwsVerifierFactory;
    }

    public void setJWSVerifierFactory(JWSVerifierFactory jWSVerifierFactory) {
        this.jwsVerifierFactory = jWSVerifierFactory;
    }

    public JWEDecrypterFactory getJWEDecrypterFactory() {
        return this.jweDecrypterFactory;
    }

    public void setJWEDecrypterFactory(JWEDecrypterFactory jWEDecrypterFactory) {
        this.jweDecrypterFactory = jWEDecrypterFactory;
    }

    public Payload process(String string, C c2) throws ParseException, BadJOSEException, JOSEException {
        return this.process(JOSEObject.parse((String)string), c2);
    }

    public Payload process(JOSEObject jOSEObject, C c2) throws BadJOSEException, JOSEException {
        if (jOSEObject instanceof JWSObject) {
            return this.process((JWSObject)jOSEObject, c2);
        }
        if (jOSEObject instanceof JWEObject) {
            return this.process((JWEObject)jOSEObject, c2);
        }
        if (jOSEObject instanceof PlainObject) {
            return this.process((PlainObject)jOSEObject, c2);
        }
        throw new JOSEException("Unexpected JOSE object type: " + jOSEObject.getClass());
    }

    public Payload process(PlainObject plainObject, C c2) throws BadJOSEException {
        if (this.jwsTypeVerifier == null) {
            throw new BadJOSEException("Unsecured (plain) JOSE object rejected: No JWS header \"typ\" (type) verifier is configured");
        }
        this.jwsTypeVerifier.verify(plainObject.getHeader().getType(), c2);
        throw new BadJOSEException("Unsecured (plain) JOSE objects are rejected, extend class to handle");
    }

    public Payload process(JWSObject jWSObject, C c2) throws BadJOSEException, JOSEException {
        if (this.jwsTypeVerifier == null) {
            throw new BadJOSEException("JWS object rejected: No JWS header \"typ\" (type) verifier is configured");
        }
        this.jwsTypeVerifier.verify(jWSObject.getHeader().getType(), c2);
        if (this.getJWSKeySelector() == null) {
            throw new BadJOSEException("JWS object rejected: No JWS key selector is configured");
        }
        if (this.getJWSVerifierFactory() == null) {
            throw new JOSEException("No JWS verifier is configured");
        }
        List list = this.getJWSKeySelector().selectJWSKeys(jWSObject.getHeader(), c2);
        if (list == null || list.isEmpty()) {
            throw new BadJOSEException("JWS object rejected: Another algorithm expected, or no matching key(s) found");
        }
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            JWSVerifier jWSVerifier = this.getJWSVerifierFactory().createJWSVerifier(jWSObject.getHeader(), (Key)listIterator.next());
            if (jWSVerifier == null) continue;
            boolean bl2 = jWSObject.verify(jWSVerifier);
            if (bl2) {
                return jWSObject.getPayload();
            }
            if (listIterator.hasNext()) continue;
            throw new BadJWSException("JWS object rejected: Invalid signature");
        }
        throw new BadJOSEException("JWS object rejected: No matching verifier(s) found");
    }

    public Payload process(JWEObject jWEObject, C c2) throws BadJOSEException, JOSEException {
        if (this.jweTypeVerifier == null) {
            throw new BadJOSEException("JWE object rejected: No JWE header \"typ\" (type) verifier is configured");
        }
        this.jweTypeVerifier.verify(jWEObject.getHeader().getType(), c2);
        if (this.getJWEKeySelector() == null) {
            throw new BadJOSEException("JWE object rejected: No JWE key selector is configured");
        }
        if (this.getJWEDecrypterFactory() == null) {
            throw new JOSEException("No JWE decrypter is configured");
        }
        List list = this.getJWEKeySelector().selectJWEKeys(jWEObject.getHeader(), c2);
        if (list == null || list.isEmpty()) {
            throw new BadJOSEException("JWE object rejected: Another algorithm expected, or no matching key(s) found");
        }
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            JWEDecrypter jWEDecrypter = this.getJWEDecrypterFactory().createJWEDecrypter(jWEObject.getHeader(), (Key)listIterator.next());
            if (jWEDecrypter == null) continue;
            try {
                jWEObject.decrypt(jWEDecrypter);
            }
            catch (JOSEException jOSEException) {
                if (listIterator.hasNext()) continue;
                throw new BadJWEException("JWE object rejected: " + jOSEException.getMessage(), (Throwable)jOSEException);
            }
            if ("JWT".equalsIgnoreCase(jWEObject.getHeader().getContentType())) {
                JWSObject jWSObject = jWEObject.getPayload().toJWSObject();
                if (jWSObject == null) {
                    return jWEObject.getPayload();
                }
                return this.process(jWSObject, c2);
            }
            return jWEObject.getPayload();
        }
        throw new BadJOSEException("JWE object rejected: No matching decrypter(s) found");
    }
}

