/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.jwk.gen;

import com.google.crypto.tink.subtle.Ed25519Sign;
import com.google.crypto.tink.subtle.X25519;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.Curve;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.OctetKeyPair;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.gen.JWKGenerator;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64URL;

public class OctetKeyPairGenerator
extends JWKGenerator<OctetKeyPair> {
    private final Curve crv;
    public static final Set<Curve> SUPPORTED_CURVES;

    public OctetKeyPairGenerator(Curve curve) {
        if (curve == null) {
            throw new IllegalArgumentException("The curve must not be null");
        }
        if (!SUPPORTED_CURVES.contains(curve)) {
            throw new IllegalArgumentException("Curve not supported for OKP generation");
        }
        this.crv = curve;
    }

    public OctetKeyPair generate() throws JOSEException {
        Base64URL base64URL;
        Base64URL base64URL2;
        Object object;
        if (this.crv.equals((Object)Curve.X25519)) {
            byte[] byArray;
            try {
                object = X25519.generatePrivateKey();
                byArray = X25519.publicFromPrivate((byte[])object);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new JOSEException(invalidKeyException.getMessage(), (Throwable)invalidKeyException);
            }
            base64URL2 = Base64URL.encode((byte[])object);
            base64URL = Base64URL.encode((byte[])byArray);
        } else if (this.crv.equals((Object)Curve.Ed25519)) {
            try {
                object = Ed25519Sign.KeyPair.newKeyPair();
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new JOSEException(generalSecurityException.getMessage(), (Throwable)generalSecurityException);
            }
            base64URL2 = Base64URL.encode((byte[])object.getPrivateKey());
            base64URL = Base64URL.encode((byte[])object.getPublicKey());
        } else {
            throw new JOSEException("Curve not supported");
        }
        object = new OctetKeyPair.Builder(this.crv, base64URL).d(base64URL2).keyUse(this.use).keyOperations(this.ops).algorithm(this.alg);
        if (this.x5tKid) {
            object.keyIDFromThumbprint();
        } else {
            object.keyID(this.kid);
        }
        return object.build();
    }

    static {
        LinkedHashSet<Curve> linkedHashSet = new LinkedHashSet<Curve>();
        linkedHashSet.add(Curve.X25519);
        linkedHashSet.add(Curve.Ed25519);
        SUPPORTED_CURVES = Collections.unmodifiableSet(linkedHashSet);
    }
}

