/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.jwk.gen;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.Curve;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.ECKey;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.gen.JWKGenerator;

public class ECKeyGenerator
extends JWKGenerator<ECKey> {
    private final Curve crv;

    public ECKeyGenerator(Curve curve) {
        if (curve == null) {
            throw new IllegalArgumentException("The curve must not be null");
        }
        this.crv = curve;
    }

    public ECKey generate() throws JOSEException {
        KeyPairGenerator keyPairGenerator;
        ECParameterSpec eCParameterSpec = this.crv.toECParameterSpec();
        try {
            keyPairGenerator = this.keyStore != null ? KeyPairGenerator.getInstance("EC", this.keyStore.getProvider()) : KeyPairGenerator.getInstance("EC");
            keyPairGenerator.initialize(eCParameterSpec);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException generalSecurityException) {
            throw new JOSEException(generalSecurityException.getMessage(), (Throwable)generalSecurityException);
        }
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        ECKey.Builder builder = new ECKey.Builder(this.crv, (ECPublicKey)keyPair.getPublic()).privateKey(keyPair.getPrivate()).keyUse(this.use).keyOperations(this.ops).algorithm(this.alg).keyStore(this.keyStore);
        if (this.x5tKid) {
            builder.keyIDFromThumbprint();
        } else {
            builder.keyID(this.kid);
        }
        return builder.build();
    }
}

