/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.jwk;

import java.net.URI;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import macromedia.externals.com.nimbusds.jose_8_2_1.Algorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.JWK;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.JWKMetadata;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.KeyOperation;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.KeyType;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.KeyUse;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.OctetSequenceKey;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.SecretJWK;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64URL;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.ByteUtils;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.IntegerOverflowException;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.JSONObjectUtils;
import macromedia.externals.net.minidev.json_1_3_1.JSONObject;
import net.jcip.annotations.Immutable;

/*
 * Exception performing whole class analysis ignored.
 */
@Immutable
public final class OctetSequenceKey
extends JWK
implements SecretJWK {
    private static final long serialVersionUID = 1L;
    private final Base64URL k;

    public OctetSequenceKey(Base64URL base64URL, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL2, Base64URL base64URL3, List<Base64> list, KeyStore keyStore) {
        super(KeyType.OCT, keyUse, set, algorithm, string, uRI, base64URL2, base64URL3, list, keyStore);
        if (base64URL == null) {
            throw new IllegalArgumentException("The key value must not be null");
        }
        this.k = base64URL;
    }

    public Base64URL getKeyValue() {
        return this.k;
    }

    public byte[] toByteArray() {
        return this.getKeyValue().decode();
    }

    public SecretKey toSecretKey() {
        return this.toSecretKey("NONE");
    }

    public SecretKey toSecretKey(String string) {
        return new SecretKeySpec(this.toByteArray(), string);
    }

    public LinkedHashMap<String, ?> getRequiredParams() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("k", this.k.toString());
        linkedHashMap.put("kty", this.getKeyType().toString());
        return linkedHashMap;
    }

    public boolean isPrivate() {
        return true;
    }

    public OctetSequenceKey toPublicJWK() {
        return null;
    }

    public int size() {
        try {
            return ByteUtils.safeBitLength((byte[])this.k.decode());
        }
        catch (IntegerOverflowException integerOverflowException) {
            throw new ArithmeticException(integerOverflowException.getMessage());
        }
    }

    public JSONObject toJSONObject() {
        JSONObject jSONObject = super.toJSONObject();
        jSONObject.put((Object)"k", (Object)this.k.toString());
        return jSONObject;
    }

    public static OctetSequenceKey parse(String string) throws ParseException {
        return OctetSequenceKey.parse((JSONObject)JSONObjectUtils.parse((String)string));
    }

    public static OctetSequenceKey parse(JSONObject jSONObject) throws ParseException {
        Base64URL base64URL = new Base64URL(JSONObjectUtils.getString((JSONObject)jSONObject, (String)"k"));
        KeyType keyType = JWKMetadata.parseKeyType((JSONObject)jSONObject);
        if (keyType != KeyType.OCT) {
            throw new ParseException("The key type \"kty\" must be oct", 0);
        }
        return new OctetSequenceKey(base64URL, JWKMetadata.parseKeyUse((JSONObject)jSONObject), JWKMetadata.parseKeyOperations((JSONObject)jSONObject), JWKMetadata.parseAlgorithm((JSONObject)jSONObject), JWKMetadata.parseKeyID((JSONObject)jSONObject), JWKMetadata.parseX509CertURL((JSONObject)jSONObject), JWKMetadata.parseX509CertThumbprint((JSONObject)jSONObject), JWKMetadata.parseX509CertSHA256Thumbprint((JSONObject)jSONObject), JWKMetadata.parseX509CertChain((JSONObject)jSONObject), null);
    }

    public static OctetSequenceKey load(KeyStore keyStore, String string, char[] cArray) throws KeyStoreException, JOSEException {
        Key key;
        try {
            key = keyStore.getKey(string, cArray);
        }
        catch (NoSuchAlgorithmException | UnrecoverableKeyException generalSecurityException) {
            throw new JOSEException("Couldn't retrieve secret key (bad pin?): " + generalSecurityException.getMessage(), (Throwable)generalSecurityException);
        }
        if (!(key instanceof SecretKey)) {
            return null;
        }
        return new Builder((SecretKey)key).keyID(string).keyStore(keyStore).build();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof OctetSequenceKey)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        OctetSequenceKey octetSequenceKey = (OctetSequenceKey)object;
        return Objects.equals(this.k, octetSequenceKey.k);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.k);
    }
}

