/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.jwk;

import java.net.URI;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import macromedia.externals.com.nimbusds.jose_8_2_1.Algorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.AsymmetricJWK;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.Curve;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.CurveBasedJWK;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.JWK;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.JWKMetadata;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.KeyOperation;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.KeyType;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.KeyUse;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64URL;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.ByteUtils;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.JSONObjectUtils;
import macromedia.externals.net.minidev.json_1_3_1.JSONObject;
import net.jcip.annotations.Immutable;

/*
 * Exception performing whole class analysis ignored.
 */
@Immutable
public class OctetKeyPair
extends JWK
implements AsymmetricJWK,
CurveBasedJWK {
    private static final long serialVersionUID = 1L;
    public static final Set<Curve> SUPPORTED_CURVES = Collections.unmodifiableSet(new HashSet<Curve>(Arrays.asList(Curve.Ed25519, Curve.Ed448, Curve.X25519, Curve.X448)));
    private final Curve crv;
    private final Base64URL x;
    private final byte[] decodedX;
    private final Base64URL d;
    private final byte[] decodedD;

    public OctetKeyPair(Curve curve, Base64URL base64URL, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL2, Base64URL base64URL3, List<Base64> list, KeyStore keyStore) {
        super(KeyType.OKP, keyUse, set, algorithm, string, uRI, base64URL2, base64URL3, list, keyStore);
        if (curve == null) {
            throw new IllegalArgumentException("The curve must not be null");
        }
        if (!SUPPORTED_CURVES.contains(curve)) {
            throw new IllegalArgumentException("Unknown / unsupported curve: " + curve);
        }
        this.crv = curve;
        if (base64URL == null) {
            throw new IllegalArgumentException("The 'x' parameter must not be null");
        }
        this.x = base64URL;
        this.decodedX = base64URL.decode();
        this.d = null;
        this.decodedD = null;
    }

    public OctetKeyPair(Curve curve, Base64URL base64URL, Base64URL base64URL2, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL3, Base64URL base64URL4, List<Base64> list, KeyStore keyStore) {
        super(KeyType.OKP, keyUse, set, algorithm, string, uRI, base64URL3, base64URL4, list, keyStore);
        if (curve == null) {
            throw new IllegalArgumentException("The curve must not be null");
        }
        if (!SUPPORTED_CURVES.contains(curve)) {
            throw new IllegalArgumentException("Unknown / unsupported curve: " + curve);
        }
        this.crv = curve;
        if (base64URL == null) {
            throw new IllegalArgumentException("The 'x' parameter must not be null");
        }
        this.x = base64URL;
        this.decodedX = base64URL.decode();
        if (base64URL2 == null) {
            throw new IllegalArgumentException("The 'd' parameter must not be null");
        }
        this.d = base64URL2;
        this.decodedD = base64URL2.decode();
    }

    public Curve getCurve() {
        return this.crv;
    }

    public Base64URL getX() {
        return this.x;
    }

    public byte[] getDecodedX() {
        return (byte[])this.decodedX.clone();
    }

    public Base64URL getD() {
        return this.d;
    }

    public byte[] getDecodedD() {
        return this.decodedD == null ? null : (byte[])this.decodedD.clone();
    }

    public PublicKey toPublicKey() throws JOSEException {
        throw new JOSEException("Export to java.security.PublicKey not supported");
    }

    public PrivateKey toPrivateKey() throws JOSEException {
        throw new JOSEException("Export to java.security.PrivateKey not supported");
    }

    public KeyPair toKeyPair() throws JOSEException {
        throw new JOSEException("Export to java.security.KeyPair not supported");
    }

    public boolean matches(X509Certificate x509Certificate) {
        return false;
    }

    public LinkedHashMap<String, ?> getRequiredParams() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("crv", this.crv.toString());
        linkedHashMap.put("kty", this.getKeyType().getValue());
        linkedHashMap.put("x", this.x.toString());
        return linkedHashMap;
    }

    public boolean isPrivate() {
        return this.d != null;
    }

    public OctetKeyPair toPublicJWK() {
        return new OctetKeyPair(this.getCurve(), this.getX(), this.getKeyUse(), this.getKeyOperations(), this.getAlgorithm(), this.getKeyID(), this.getX509CertURL(), this.getX509CertThumbprint(), this.getX509CertSHA256Thumbprint(), this.getX509CertChain(), this.getKeyStore());
    }

    public JSONObject toJSONObject() {
        JSONObject jSONObject = super.toJSONObject();
        jSONObject.put((Object)"crv", (Object)this.crv.toString());
        jSONObject.put((Object)"x", (Object)this.x.toString());
        if (this.d != null) {
            jSONObject.put((Object)"d", (Object)this.d.toString());
        }
        return jSONObject;
    }

    public int size() {
        return ByteUtils.bitLength((byte[])this.x.decode());
    }

    public static OctetKeyPair parse(String string) throws ParseException {
        return OctetKeyPair.parse((JSONObject)JSONObjectUtils.parse((String)string));
    }

    public static OctetKeyPair parse(JSONObject jSONObject) throws ParseException {
        Curve curve = Curve.parse((String)JSONObjectUtils.getString((JSONObject)jSONObject, (String)"crv"));
        Base64URL base64URL = new Base64URL(JSONObjectUtils.getString((JSONObject)jSONObject, (String)"x"));
        KeyType keyType = JWKMetadata.parseKeyType((JSONObject)jSONObject);
        if (keyType != KeyType.OKP) {
            throw new ParseException("The key type \"kty\" must be OKP", 0);
        }
        Base64URL base64URL2 = null;
        if (jSONObject.get((Object)"d") != null) {
            base64URL2 = new Base64URL(JSONObjectUtils.getString((JSONObject)jSONObject, (String)"d"));
        }
        try {
            if (base64URL2 == null) {
                return new OctetKeyPair(curve, base64URL, JWKMetadata.parseKeyUse((JSONObject)jSONObject), JWKMetadata.parseKeyOperations((JSONObject)jSONObject), JWKMetadata.parseAlgorithm((JSONObject)jSONObject), JWKMetadata.parseKeyID((JSONObject)jSONObject), JWKMetadata.parseX509CertURL((JSONObject)jSONObject), JWKMetadata.parseX509CertThumbprint((JSONObject)jSONObject), JWKMetadata.parseX509CertSHA256Thumbprint((JSONObject)jSONObject), JWKMetadata.parseX509CertChain((JSONObject)jSONObject), null);
            }
            return new OctetKeyPair(curve, base64URL, base64URL2, JWKMetadata.parseKeyUse((JSONObject)jSONObject), JWKMetadata.parseKeyOperations((JSONObject)jSONObject), JWKMetadata.parseAlgorithm((JSONObject)jSONObject), JWKMetadata.parseKeyID((JSONObject)jSONObject), JWKMetadata.parseX509CertURL((JSONObject)jSONObject), JWKMetadata.parseX509CertThumbprint((JSONObject)jSONObject), JWKMetadata.parseX509CertSHA256Thumbprint((JSONObject)jSONObject), JWKMetadata.parseX509CertChain((JSONObject)jSONObject), null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException(illegalArgumentException.getMessage(), 0);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof OctetKeyPair)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        OctetKeyPair octetKeyPair = (OctetKeyPair)object;
        return Objects.equals(this.crv, octetKeyPair.crv) && Objects.equals(this.x, octetKeyPair.x) && Arrays.equals(this.decodedX, octetKeyPair.decodedX) && Objects.equals(this.d, octetKeyPair.d) && Arrays.equals(this.decodedD, octetKeyPair.decodedD);
    }

    public int hashCode() {
        int n2 = Objects.hash(super.hashCode(), this.crv, this.x, this.d);
        n2 = 31 * n2 + Arrays.hashCode(this.decodedX);
        n2 = 31 * n2 + Arrays.hashCode(this.decodedD);
        return n2;
    }

    static /* synthetic */ Curve access$000(OctetKeyPair octetKeyPair) {
        return octetKeyPair.crv;
    }

    static /* synthetic */ Base64URL access$100(OctetKeyPair octetKeyPair) {
        return octetKeyPair.x;
    }

    static /* synthetic */ Base64URL access$200(OctetKeyPair octetKeyPair) {
        return octetKeyPair.d;
    }
}

