/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.jwk;

import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.Objects;

public final class KeyUse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final KeyUse SIGNATURE = new KeyUse("sig");
    public static final KeyUse ENCRYPTION = new KeyUse("enc");
    private final String identifier;

    public KeyUse(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The key use identifier must not be null");
        }
        this.identifier = string;
    }

    public String identifier() {
        return this.identifier;
    }

    public String getValue() {
        return this.identifier();
    }

    public String toString() {
        return this.identifier();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof KeyUse)) {
            return false;
        }
        KeyUse keyUse = (KeyUse)object;
        return Objects.equals(this.identifier, keyUse.identifier);
    }

    public int hashCode() {
        return Objects.hash(this.identifier);
    }

    public static KeyUse parse(String string) throws ParseException {
        if (string == null) {
            return null;
        }
        if (string.equals(SIGNATURE.identifier())) {
            return SIGNATURE;
        }
        if (string.equals(ENCRYPTION.identifier())) {
            return ENCRYPTION;
        }
        if (string.trim().isEmpty()) {
            throw new ParseException("JWK use value must not be empty or blank", 0);
        }
        return new KeyUse(string);
    }

    public static KeyUse from(X509Certificate x509Certificate) {
        if (x509Certificate.getKeyUsage() == null) {
            return null;
        }
        if (x509Certificate.getKeyUsage()[1]) {
            return SIGNATURE;
        }
        if (x509Certificate.getKeyUsage()[0] && x509Certificate.getKeyUsage()[2]) {
            return ENCRYPTION;
        }
        if (x509Certificate.getKeyUsage()[0] && x509Certificate.getKeyUsage()[4]) {
            return ENCRYPTION;
        }
        if (x509Certificate.getKeyUsage()[2] || x509Certificate.getKeyUsage()[3] || x509Certificate.getKeyUsage()[4]) {
            return ENCRYPTION;
        }
        if (x509Certificate.getKeyUsage()[5] || x509Certificate.getKeyUsage()[6]) {
            return SIGNATURE;
        }
        return null;
    }
}

