/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.jwk;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.ECKey;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.JWK;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.OctetSequenceKey;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.PasswordLookup;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.RSAKey;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.DefaultResourceRetriever;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.IOUtils;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.JSONObjectUtils;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Resource;
import macromedia.externals.net.minidev.json_1_3_1.JSONArray;
import macromedia.externals.net.minidev.json_1_3_1.JSONObject;
import net.jcip.annotations.Immutable;

/*
 * Exception performing whole class analysis ignored.
 */
@Immutable
public class JWKSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String MIME_TYPE = "application/jwk-set+json; charset=UTF-8";
    private final List<JWK> keys;
    private final Map<String, Object> customMembers;

    public JWKSet() {
        this(Collections.emptyList());
    }

    public JWKSet(JWK jWK) {
        this(Collections.singletonList(jWK));
        if (jWK == null) {
            throw new IllegalArgumentException("The JWK must not be null");
        }
    }

    public JWKSet(List<JWK> list) {
        this(list, Collections.emptyMap());
    }

    public JWKSet(List<JWK> list, Map<String, Object> map) {
        if (list == null) {
            throw new IllegalArgumentException("The JWK list must not be null");
        }
        this.keys = Collections.unmodifiableList(list);
        this.customMembers = Collections.unmodifiableMap(map);
    }

    public List<JWK> getKeys() {
        return this.keys;
    }

    public JWK getKeyByKeyId(String string) {
        for (JWK jWK : this.getKeys()) {
            if (jWK.getKeyID() == null || !jWK.getKeyID().equals(string)) continue;
            return jWK;
        }
        return null;
    }

    public Map<String, Object> getAdditionalMembers() {
        return this.customMembers;
    }

    public JWKSet toPublicJWKSet() {
        LinkedList<JWK> linkedList = new LinkedList<JWK>();
        for (JWK jWK : this.keys) {
            JWK jWK2 = jWK.toPublicJWK();
            if (jWK2 == null) continue;
            linkedList.add(jWK2);
        }
        return new JWKSet(linkedList, this.customMembers);
    }

    public JSONObject toJSONObject() {
        return this.toJSONObject(true);
    }

    public JSONObject toJSONObject(boolean bl2) {
        JSONObject jSONObject = new JSONObject(this.customMembers);
        JSONArray jSONArray = new JSONArray();
        for (JWK jWK : this.keys) {
            if (bl2) {
                JWK jWK2 = jWK.toPublicJWK();
                if (jWK2 == null) continue;
                jSONArray.add((Object)jWK2.toJSONObject());
                continue;
            }
            jSONArray.add((Object)jWK.toJSONObject());
        }
        jSONObject.put((Object)"keys", (Object)jSONArray);
        return jSONObject;
    }

    public String toString() {
        return this.toJSONObject().toString();
    }

    public static JWKSet parse(String string) throws ParseException {
        return JWKSet.parse((JSONObject)JSONObjectUtils.parse((String)string));
    }

    public static JWKSet parse(JSONObject jSONObject) throws ParseException {
        JSONArray jSONArray = JSONObjectUtils.getJSONArray((JSONObject)jSONObject, (String)"keys");
        if (jSONArray == null) {
            throw new ParseException("Missing required \"keys\" member", 0);
        }
        LinkedList<JWK> linkedList = new LinkedList<JWK>();
        for (int i2 = 0; i2 < jSONArray.size(); ++i2) {
            if (!(jSONArray.get(i2) instanceof JSONObject)) {
                throw new ParseException("The \"keys\" JSON array must contain JSON objects only", 0);
            }
            JSONObject jSONObject2 = (JSONObject)jSONArray.get(i2);
            try {
                linkedList.add(JWK.parse((JSONObject)jSONObject2));
                continue;
            }
            catch (ParseException parseException) {
                throw new ParseException("Invalid JWK at position " + i2 + ": " + parseException.getMessage(), 0);
            }
        }
        HashMap hashMap = new HashMap();
        for (Map.Entry entry : jSONObject.entrySet()) {
            if (entry.getKey() == null || ((String)entry.getKey()).equals("keys")) continue;
            hashMap.put(entry.getKey(), entry.getValue());
        }
        return new JWKSet(linkedList, hashMap);
    }

    public static JWKSet load(InputStream inputStream) throws IOException, ParseException {
        return JWKSet.parse((String)IOUtils.readInputStreamToString((InputStream)inputStream, (Charset)Charset.forName("UTF-8")));
    }

    public static JWKSet load(File file) throws IOException, ParseException {
        return JWKSet.parse((String)IOUtils.readFileToString((File)file, (Charset)Charset.forName("UTF-8")));
    }

    public static JWKSet load(URL uRL, int n2, int n3, int n4) throws IOException, ParseException {
        return JWKSet.load((URL)uRL, (int)n2, (int)n3, (int)n4, null);
    }

    public static JWKSet load(URL uRL, int n2, int n3, int n4, Proxy proxy) throws IOException, ParseException {
        DefaultResourceRetriever defaultResourceRetriever = new DefaultResourceRetriever(n2, n3, n4);
        defaultResourceRetriever.setProxy(proxy);
        Resource resource = defaultResourceRetriever.retrieveResource(uRL);
        return JWKSet.parse((String)resource.getContent());
    }

    public static JWKSet load(URL uRL) throws IOException, ParseException {
        return JWKSet.load((URL)uRL, (int)0, (int)0, (int)0);
    }

    public static JWKSet load(KeyStore keyStore, PasswordLookup passwordLookup) throws KeyStoreException {
        Certificate certificate;
        char[] cArray;
        String string;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            RSAKey rSAKey;
            string = enumeration.nextElement();
            char[] cArray2 = cArray = passwordLookup == null ? "".toCharArray() : passwordLookup.lookupPassword(string);
            certificate = keyStore.getCertificate(string);
            if (certificate == null) continue;
            if (certificate.getPublicKey() instanceof RSAPublicKey) {
                try {
                    rSAKey = RSAKey.load((KeyStore)keyStore, (String)string, (char[])cArray);
                }
                catch (JOSEException jOSEException) {
                    continue;
                }
                if (rSAKey == null) continue;
                linkedList.add(rSAKey);
                continue;
            }
            if (!(certificate.getPublicKey() instanceof ECPublicKey)) continue;
            try {
                rSAKey = ECKey.load((KeyStore)keyStore, (String)string, (char[])cArray);
            }
            catch (JOSEException jOSEException) {
                continue;
            }
            if (rSAKey == null) continue;
            linkedList.add(rSAKey);
        }
        enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            string = enumeration.nextElement();
            cArray = passwordLookup == null ? "".toCharArray() : passwordLookup.lookupPassword(string);
            try {
                certificate = OctetSequenceKey.load((KeyStore)keyStore, (String)string, (char[])cArray);
            }
            catch (JOSEException jOSEException) {
                continue;
            }
            if (certificate == null) continue;
            linkedList.add(certificate);
        }
        return new JWKSet(linkedList);
    }
}

