/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.jwk;

import java.util.LinkedList;
import java.util.List;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.JWK;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.JWKMatcher;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.JWKSet;
import net.jcip.annotations.Immutable;

@Immutable
public final class JWKSelector {
    private final JWKMatcher matcher;

    public JWKSelector(JWKMatcher jWKMatcher) {
        if (jWKMatcher == null) {
            throw new IllegalArgumentException("The JWK matcher must not be null");
        }
        this.matcher = jWKMatcher;
    }

    public JWKMatcher getMatcher() {
        return this.matcher;
    }

    public List<JWK> select(JWKSet jWKSet) {
        LinkedList<JWK> linkedList = new LinkedList<JWK>();
        if (jWKSet == null) {
            return linkedList;
        }
        for (JWK jWK : jWKSet.getKeys()) {
            if (!this.matcher.matches(jWK)) continue;
            linkedList.add(jWK);
        }
        return linkedList;
    }
}

