/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.jwk;

import java.net.URI;
import java.text.ParseException;
import java.util.List;
import java.util.Set;
import macromedia.externals.com.nimbusds.jose_8_2_1.Algorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.KeyOperation;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.KeyType;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.KeyUse;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64URL;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.JSONObjectUtils;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.X509CertChainUtils;
import macromedia.externals.net.minidev.json_1_3_1.JSONArray;
import macromedia.externals.net.minidev.json_1_3_1.JSONObject;

final class JWKMetadata {
    JWKMetadata() {
    }

    static KeyType parseKeyType(JSONObject jSONObject) throws ParseException {
        return KeyType.parse((String)JSONObjectUtils.getString((JSONObject)jSONObject, (String)"kty"));
    }

    static KeyUse parseKeyUse(JSONObject jSONObject) throws ParseException {
        if (jSONObject.containsKey((Object)"use")) {
            return KeyUse.parse((String)JSONObjectUtils.getString((JSONObject)jSONObject, (String)"use"));
        }
        return null;
    }

    static Set<KeyOperation> parseKeyOperations(JSONObject jSONObject) throws ParseException {
        if (jSONObject.containsKey((Object)"key_ops")) {
            return KeyOperation.parse((List)JSONObjectUtils.getStringList((JSONObject)jSONObject, (String)"key_ops"));
        }
        return null;
    }

    static Algorithm parseAlgorithm(JSONObject jSONObject) throws ParseException {
        if (jSONObject.containsKey((Object)"alg")) {
            return new Algorithm(JSONObjectUtils.getString((JSONObject)jSONObject, (String)"alg"));
        }
        return null;
    }

    static String parseKeyID(JSONObject jSONObject) throws ParseException {
        if (jSONObject.containsKey((Object)"kid")) {
            return JSONObjectUtils.getString((JSONObject)jSONObject, (String)"kid");
        }
        return null;
    }

    static URI parseX509CertURL(JSONObject jSONObject) throws ParseException {
        if (jSONObject.containsKey((Object)"x5u")) {
            return JSONObjectUtils.getURI((JSONObject)jSONObject, (String)"x5u");
        }
        return null;
    }

    static Base64URL parseX509CertThumbprint(JSONObject jSONObject) throws ParseException {
        if (jSONObject.containsKey((Object)"x5t")) {
            return new Base64URL(JSONObjectUtils.getString((JSONObject)jSONObject, (String)"x5t"));
        }
        return null;
    }

    static Base64URL parseX509CertSHA256Thumbprint(JSONObject jSONObject) throws ParseException {
        if (jSONObject.containsKey((Object)"x5t#S256")) {
            return new Base64URL(JSONObjectUtils.getString((JSONObject)jSONObject, (String)"x5t#S256"));
        }
        return null;
    }

    static List<Base64> parseX509CertChain(JSONObject jSONObject) throws ParseException {
        if (jSONObject.containsKey((Object)"x5c")) {
            List list = X509CertChainUtils.toBase64List((JSONArray)JSONObjectUtils.getJSONArray((JSONObject)jSONObject, (String)"x5c"));
            if (list.isEmpty()) {
                throw new ParseException("The X.509 certificate chain \"x5c\" must not be empty", 0);
            }
            return list;
        }
        return null;
    }
}

