/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.jwk;

import java.util.Set;
import macromedia.externals.com.nimbusds.jose_8_2_1.Algorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEHeader;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSAlgorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSHeader;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.Curve;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.CurveBasedJWK;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.JWK;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.JWKMatcher;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.KeyOperation;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.KeyType;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.KeyUse;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64URL;
import net.jcip.annotations.Immutable;

/*
 * Exception performing whole class analysis ignored.
 */
@Immutable
public class JWKMatcher {
    private final Set<KeyType> types;
    private final Set<KeyUse> uses;
    private final Set<KeyOperation> ops;
    private final Set<Algorithm> algs;
    private final Set<String> ids;
    private final boolean hasUse;
    private final boolean hasID;
    private final boolean privateOnly;
    private final boolean publicOnly;
    private final int minSizeBits;
    private final int maxSizeBits;
    private final Set<Integer> sizesBits;
    private final Set<Curve> curves;
    private final Set<Base64URL> x5tS256s;

    @Deprecated
    public JWKMatcher(Set<KeyType> set, Set<KeyUse> set2, Set<KeyOperation> set3, Set<Algorithm> set4, Set<String> set5, boolean bl2, boolean bl3) {
        this(set, set2, set3, set4, set5, bl2, bl3, 0, 0);
    }

    @Deprecated
    public JWKMatcher(Set<KeyType> set, Set<KeyUse> set2, Set<KeyOperation> set3, Set<Algorithm> set4, Set<String> set5, boolean bl2, boolean bl3, int n2, int n3) {
        this(set, set2, set3, set4, set5, bl2, bl3, n2, n3, null);
    }

    @Deprecated
    public JWKMatcher(Set<KeyType> set, Set<KeyUse> set2, Set<KeyOperation> set3, Set<Algorithm> set4, Set<String> set5, boolean bl2, boolean bl3, int n2, int n3, Set<Curve> set6) {
        this(set, set2, set3, set4, set5, bl2, bl3, n2, n3, null, set6);
    }

    @Deprecated
    public JWKMatcher(Set<KeyType> set, Set<KeyUse> set2, Set<KeyOperation> set3, Set<Algorithm> set4, Set<String> set5, boolean bl2, boolean bl3, int n2, int n3, Set<Integer> set6, Set<Curve> set7) {
        this(set, set2, set3, set4, set5, false, false, bl2, bl3, n2, n3, set6, set7);
    }

    @Deprecated
    public JWKMatcher(Set<KeyType> set, Set<KeyUse> set2, Set<KeyOperation> set3, Set<Algorithm> set4, Set<String> set5, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n2, int n3, Set<Integer> set6, Set<Curve> set7) {
        this(set, set2, set3, set4, set5, bl2, bl3, bl4, bl5, n2, n3, set6, set7, null);
    }

    public JWKMatcher(Set<KeyType> set, Set<KeyUse> set2, Set<KeyOperation> set3, Set<Algorithm> set4, Set<String> set5, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n2, int n3, Set<Integer> set6, Set<Curve> set7, Set<Base64URL> set8) {
        this.types = set;
        this.uses = set2;
        this.ops = set3;
        this.algs = set4;
        this.ids = set5;
        this.hasUse = bl2;
        this.hasID = bl3;
        this.privateOnly = bl4;
        this.publicOnly = bl5;
        this.minSizeBits = n2;
        this.maxSizeBits = n3;
        this.sizesBits = set6;
        this.curves = set7;
        this.x5tS256s = set8;
    }

    public static JWKMatcher forJWEHeader(JWEHeader jWEHeader) {
        return new Builder().keyType(KeyType.forAlgorithm((Algorithm)jWEHeader.getAlgorithm())).keyID(jWEHeader.getKeyID()).keyUses(new KeyUse[]{KeyUse.ENCRYPTION, null}).algorithms(new Algorithm[]{jWEHeader.getAlgorithm(), null}).build();
    }

    public static JWKMatcher forJWSHeader(JWSHeader jWSHeader) {
        JWSAlgorithm jWSAlgorithm = jWSHeader.getAlgorithm();
        if (JWSAlgorithm.Family.RSA.contains((Object)jWSAlgorithm) || JWSAlgorithm.Family.EC.contains((Object)jWSAlgorithm)) {
            return new Builder().keyType(KeyType.forAlgorithm((Algorithm)jWSAlgorithm)).keyID(jWSHeader.getKeyID()).keyUses(new KeyUse[]{KeyUse.SIGNATURE, null}).algorithms(new Algorithm[]{jWSAlgorithm, null}).x509CertSHA256Thumbprint(jWSHeader.getX509CertSHA256Thumbprint()).build();
        }
        if (JWSAlgorithm.Family.HMAC_SHA.contains((Object)jWSAlgorithm)) {
            return new Builder().keyType(KeyType.forAlgorithm((Algorithm)jWSAlgorithm)).keyID(jWSHeader.getKeyID()).privateOnly(true).algorithms(new Algorithm[]{jWSAlgorithm, null}).build();
        }
        return null;
    }

    public Set<KeyType> getKeyTypes() {
        return this.types;
    }

    public Set<KeyUse> getKeyUses() {
        return this.uses;
    }

    public Set<KeyOperation> getKeyOperations() {
        return this.ops;
    }

    public Set<Algorithm> getAlgorithms() {
        return this.algs;
    }

    public Set<String> getKeyIDs() {
        return this.ids;
    }

    public boolean hasKeyUse() {
        return this.hasUse;
    }

    public boolean hasKeyID() {
        return this.hasID;
    }

    public boolean isPrivateOnly() {
        return this.privateOnly;
    }

    public boolean isPublicOnly() {
        return this.publicOnly;
    }

    @Deprecated
    public int getMinSize() {
        return this.getMinKeySize();
    }

    public int getMinKeySize() {
        return this.minSizeBits;
    }

    @Deprecated
    public int getMaxSize() {
        return this.getMaxKeySize();
    }

    public int getMaxKeySize() {
        return this.maxSizeBits;
    }

    public Set<Integer> getKeySizes() {
        return this.sizesBits;
    }

    public Set<Curve> getCurves() {
        return this.curves;
    }

    public Set<Base64URL> getX509CertSHA256Thumbprints() {
        return this.x5tS256s;
    }

    public boolean matches(JWK jWK) {
        if (this.hasUse && jWK.getKeyUse() == null) {
            return false;
        }
        if (this.hasID && (jWK.getKeyID() == null || jWK.getKeyID().trim().isEmpty())) {
            return false;
        }
        if (this.privateOnly && !jWK.isPrivate()) {
            return false;
        }
        if (this.publicOnly && jWK.isPrivate()) {
            return false;
        }
        if (this.types != null && !this.types.contains(jWK.getKeyType())) {
            return false;
        }
        if (this.uses != null && !this.uses.contains(jWK.getKeyUse())) {
            return false;
        }
        if (!(this.ops == null || this.ops.contains(null) && jWK.getKeyOperations() == null || jWK.getKeyOperations() != null && this.ops.containsAll(jWK.getKeyOperations()))) {
            return false;
        }
        if (this.algs != null && !this.algs.contains(jWK.getAlgorithm())) {
            return false;
        }
        if (this.ids != null && !this.ids.contains(jWK.getKeyID())) {
            return false;
        }
        if (this.minSizeBits > 0 && jWK.size() < this.minSizeBits) {
            return false;
        }
        if (this.maxSizeBits > 0 && jWK.size() > this.maxSizeBits) {
            return false;
        }
        if (this.sizesBits != null && !this.sizesBits.contains(jWK.size())) {
            return false;
        }
        if (this.curves != null) {
            if (!(jWK instanceof CurveBasedJWK)) {
                return false;
            }
            CurveBasedJWK curveBasedJWK = (CurveBasedJWK)jWK;
            if (!this.curves.contains(curveBasedJWK.getCurve())) {
                return false;
            }
        }
        return this.x5tS256s == null || this.x5tS256s.contains(jWK.getX509CertSHA256Thumbprint());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        JWKMatcher.append((StringBuilder)stringBuilder, (String)"kty", (Set)this.types);
        JWKMatcher.append((StringBuilder)stringBuilder, (String)"use", (Set)this.uses);
        JWKMatcher.append((StringBuilder)stringBuilder, (String)"key_ops", (Set)this.ops);
        JWKMatcher.append((StringBuilder)stringBuilder, (String)"alg", (Set)this.algs);
        JWKMatcher.append((StringBuilder)stringBuilder, (String)"kid", (Set)this.ids);
        if (this.hasUse) {
            stringBuilder.append("has_use=true ");
        }
        if (this.hasID) {
            stringBuilder.append("has_id=true ");
        }
        if (this.privateOnly) {
            stringBuilder.append("private_only=true ");
        }
        if (this.publicOnly) {
            stringBuilder.append("public_only=true ");
        }
        if (this.minSizeBits > 0) {
            stringBuilder.append("min_size=" + this.minSizeBits + " ");
        }
        if (this.maxSizeBits > 0) {
            stringBuilder.append("max_size=" + this.maxSizeBits + " ");
        }
        JWKMatcher.append((StringBuilder)stringBuilder, (String)"size", (Set)this.sizesBits);
        JWKMatcher.append((StringBuilder)stringBuilder, (String)"crv", (Set)this.curves);
        JWKMatcher.append((StringBuilder)stringBuilder, (String)"x5t#S256", (Set)this.x5tS256s);
        return stringBuilder.toString().trim();
    }

    private static void append(StringBuilder stringBuilder, String string, Set<?> set) {
        if (set != null) {
            stringBuilder.append(string);
            stringBuilder.append('=');
            if (set.size() == 1) {
                Object obj = set.iterator().next();
                if (obj == null) {
                    stringBuilder.append("ANY");
                } else {
                    stringBuilder.append(obj.toString().trim());
                }
            } else {
                stringBuilder.append(set.toString().trim());
            }
            stringBuilder.append(' ');
        }
    }
}

