/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl;

import java.security.Key;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.CipherHelper;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class RSA_OAEP {
    private static final String RSA_OEAP_JCA_ALG = "RSA/ECB/OAEPWithSHA-1AndMGF1Padding";

    public static byte[] encryptCEK(RSAPublicKey rSAPublicKey, SecretKey secretKey, Provider provider) throws JOSEException {
        try {
            Cipher cipher = CipherHelper.getInstance((String)RSA_OEAP_JCA_ALG, (Provider)provider);
            cipher.init(1, (Key)rSAPublicKey, new SecureRandom());
            return cipher.doFinal(secretKey.getEncoded());
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new JOSEException("RSA block size exception: The RSA key is too short, try a longer one", (Throwable)illegalBlockSizeException);
        }
        catch (Exception exception) {
            throw new JOSEException(exception.getMessage(), (Throwable)exception);
        }
    }

    public static SecretKey decryptCEK(PrivateKey privateKey, byte[] byArray, Provider provider) throws JOSEException {
        try {
            Cipher cipher = CipherHelper.getInstance((String)RSA_OEAP_JCA_ALG, (Provider)provider);
            cipher.init(2, privateKey);
            return new SecretKeySpec(cipher.doFinal(byArray), "AES");
        }
        catch (Exception exception) {
            throw new JOSEException(exception.getMessage(), (Throwable)exception);
        }
    }

    private RSA_OAEP() {
    }
}

