/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Signature;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.Collection;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSAlgorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.AlgorithmSupportMessage;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.RSASSAProvider;

public class RSASSA {
    public static Signature getSignerAndVerifier(JWSAlgorithm jWSAlgorithm, Provider provider) throws JOSEException {
        Signature signature;
        String string;
        PSSParameterSpec pSSParameterSpec = null;
        if (jWSAlgorithm.equals((Object)JWSAlgorithm.RS256)) {
            string = "SHA256withRSA";
        } else if (jWSAlgorithm.equals((Object)JWSAlgorithm.RS384)) {
            string = "SHA384withRSA";
        } else if (jWSAlgorithm.equals((Object)JWSAlgorithm.RS512)) {
            string = "SHA512withRSA";
        } else if (jWSAlgorithm.equals((Object)JWSAlgorithm.PS256)) {
            string = "SHA256withRSAandMGF1";
            pSSParameterSpec = new PSSParameterSpec("SHA256", "MGF1", MGF1ParameterSpec.SHA256, 32, 1);
        } else if (jWSAlgorithm.equals((Object)JWSAlgorithm.PS384)) {
            string = "SHA384withRSAandMGF1";
            pSSParameterSpec = new PSSParameterSpec("SHA384", "MGF1", MGF1ParameterSpec.SHA384, 48, 1);
        } else if (jWSAlgorithm.equals((Object)JWSAlgorithm.PS512)) {
            string = "SHA512withRSAandMGF1";
            pSSParameterSpec = new PSSParameterSpec("SHA512", "MGF1", MGF1ParameterSpec.SHA512, 64, 1);
        } else {
            throw new JOSEException(AlgorithmSupportMessage.unsupportedJWSAlgorithm((JWSAlgorithm)jWSAlgorithm, (Collection)RSASSAProvider.SUPPORTED_ALGORITHMS));
        }
        try {
            signature = provider != null ? Signature.getInstance(string, provider) : Signature.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new JOSEException("Unsupported RSASSA algorithm: " + noSuchAlgorithmException.getMessage(), (Throwable)noSuchAlgorithmException);
        }
        if (pSSParameterSpec != null) {
            try {
                signature.setParameter(pSSParameterSpec);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new JOSEException("Invalid RSASSA-PSS salt length parameter: " + invalidAlgorithmParameterException.getMessage(), (Throwable)invalidAlgorithmParameterException);
            }
        }
        return signature;
    }

    private RSASSA() {
    }
}

