/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl;

import java.security.Provider;
import java.util.Collection;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEAlgorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.AlgorithmSupportMessage;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.PasswordBasedCryptoProvider;
import net.jcip.annotations.Immutable;

@Immutable
public final class PRFParams {
    private final String jcaMacAlg;
    private final Provider macProvider;
    private final int dkLen;

    public PRFParams(String string, Provider provider, int n2) {
        this.jcaMacAlg = string;
        this.macProvider = provider;
        this.dkLen = n2;
    }

    public String getMACAlgorithm() {
        return this.jcaMacAlg;
    }

    public Provider getMacProvider() {
        return this.macProvider;
    }

    public int getDerivedKeyByteLength() {
        return this.dkLen;
    }

    public static PRFParams resolve(JWEAlgorithm jWEAlgorithm, Provider provider) throws JOSEException {
        int n2;
        String string;
        if (JWEAlgorithm.PBES2_HS256_A128KW.equals((Object)jWEAlgorithm)) {
            string = "HmacSHA256";
            n2 = 16;
        } else if (JWEAlgorithm.PBES2_HS384_A192KW.equals((Object)jWEAlgorithm)) {
            string = "HmacSHA384";
            n2 = 24;
        } else if (JWEAlgorithm.PBES2_HS512_A256KW.equals((Object)jWEAlgorithm)) {
            string = "HmacSHA512";
            n2 = 32;
        } else {
            throw new JOSEException(AlgorithmSupportMessage.unsupportedJWEAlgorithm((JWEAlgorithm)jWEAlgorithm, (Collection)PasswordBasedCryptoProvider.SUPPORTED_ALGORITHMS));
        }
        return new PRFParams(string, provider, n2);
    }
}

