/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl;

import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Signature;
import java.security.interfaces.ECKey;
import java.security.spec.ECParameterSpec;
import java.util.Collection;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSAlgorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.AlgorithmSupportMessage;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.ECDSAProvider;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.Curve;

/*
 * Exception performing whole class analysis ignored.
 */
public class ECDSA {
    public static JWSAlgorithm resolveAlgorithm(ECKey eCKey) throws JOSEException {
        ECParameterSpec eCParameterSpec = eCKey.getParams();
        return ECDSA.resolveAlgorithm((Curve)Curve.forECParameterSpec((ECParameterSpec)eCParameterSpec));
    }

    public static JWSAlgorithm resolveAlgorithm(Curve curve) throws JOSEException {
        if (curve == null) {
            throw new JOSEException("The EC key curve is not supported, must be P-256, P-384 or P-521");
        }
        if (Curve.P_256.equals((Object)curve)) {
            return JWSAlgorithm.ES256;
        }
        if (Curve.P_256K.equals((Object)curve)) {
            return JWSAlgorithm.ES256K;
        }
        if (Curve.P_384.equals((Object)curve)) {
            return JWSAlgorithm.ES384;
        }
        if (Curve.P_521.equals((Object)curve)) {
            return JWSAlgorithm.ES512;
        }
        throw new JOSEException("Unexpected curve: " + curve);
    }

    public static Signature getSignerAndVerifier(JWSAlgorithm jWSAlgorithm, Provider provider) throws JOSEException {
        String string;
        if (jWSAlgorithm.equals((Object)JWSAlgorithm.ES256)) {
            string = "SHA256withECDSA";
        } else if (jWSAlgorithm.equals((Object)JWSAlgorithm.ES256K)) {
            string = "SHA256withECDSA";
        } else if (jWSAlgorithm.equals((Object)JWSAlgorithm.ES384)) {
            string = "SHA384withECDSA";
        } else if (jWSAlgorithm.equals((Object)JWSAlgorithm.ES512)) {
            string = "SHA512withECDSA";
        } else {
            throw new JOSEException(AlgorithmSupportMessage.unsupportedJWSAlgorithm((JWSAlgorithm)jWSAlgorithm, (Collection)ECDSAProvider.SUPPORTED_ALGORITHMS));
        }
        try {
            if (provider != null) {
                return Signature.getInstance(string, provider);
            }
            return Signature.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new JOSEException("Unsupported ECDSA algorithm: " + noSuchAlgorithmException.getMessage(), (Throwable)noSuchAlgorithmException);
        }
    }

    public static int getSignatureByteArrayLength(JWSAlgorithm jWSAlgorithm) throws JOSEException {
        if (jWSAlgorithm.equals((Object)JWSAlgorithm.ES256)) {
            return 64;
        }
        if (jWSAlgorithm.equals((Object)JWSAlgorithm.ES256K)) {
            return 64;
        }
        if (jWSAlgorithm.equals((Object)JWSAlgorithm.ES384)) {
            return 96;
        }
        if (jWSAlgorithm.equals((Object)JWSAlgorithm.ES512)) {
            return 132;
        }
        throw new JOSEException(AlgorithmSupportMessage.unsupportedJWSAlgorithm((JWSAlgorithm)jWSAlgorithm, (Collection)ECDSAProvider.SUPPORTED_ALGORITHMS));
    }

    public static byte[] transcodeSignatureToConcat(byte[] byArray, int n2) throws JOSEException {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        if (byArray.length < 8 || byArray[0] != 48) {
            throw new JOSEException("Invalid ECDSA signature format");
        }
        if (byArray[1] > 0) {
            n7 = 2;
        } else if (byArray[1] == -127) {
            n7 = 3;
        } else {
            throw new JOSEException("Invalid ECDSA signature format");
        }
        for (n6 = n5 = byArray[n7 + 1]; n6 > 0 && byArray[n7 + 2 + n5 - n6] == 0; --n6) {
        }
        for (n4 = n3 = byArray[n7 + 2 + n5 + 1]; n4 > 0 && byArray[n7 + 2 + n5 + 2 + n3 - n4] == 0; --n4) {
        }
        int n8 = Math.max(n6, n4);
        n8 = Math.max(n8, n2 / 2);
        if ((byArray[n7 - 1] & 0xFF) != byArray.length - n7 || (byArray[n7 - 1] & 0xFF) != 2 + n5 + 2 + n3 || byArray[n7] != 2 || byArray[n7 + 2 + n5] != 2) {
            throw new JOSEException("Invalid ECDSA signature format");
        }
        byte[] byArray2 = new byte[2 * n8];
        System.arraycopy(byArray, n7 + 2 + n5 - n6, byArray2, n8 - n6, n6);
        System.arraycopy(byArray, n7 + 2 + n5 + 2 + n3 - n4, byArray2, 2 * n8 - n4, n4);
        return byArray2;
    }

    public static byte[] transcodeSignatureToDER(byte[] byArray) throws JOSEException {
        int n2;
        byte[] byArray2;
        int n3;
        int n4;
        int n5;
        int n6;
        for (n6 = n5 = byArray.length / 2; n6 > 0 && byArray[n5 - n6] == 0; --n6) {
        }
        int n7 = n6;
        if (byArray[n5 - n6] < 0) {
            ++n7;
        }
        for (n4 = n5; n4 > 0 && byArray[2 * n5 - n4] == 0; --n4) {
        }
        int n8 = n4;
        if (byArray[2 * n5 - n4] < 0) {
            ++n8;
        }
        if ((n3 = 2 + n7 + 2 + n8) > 255) {
            throw new JOSEException("Invalid ECDSA signature format");
        }
        if (n3 < 128) {
            byArray2 = new byte[4 + n7 + 2 + n8];
            n2 = 1;
        } else {
            byArray2 = new byte[5 + n7 + 2 + n8];
            byArray2[1] = -127;
            n2 = 2;
        }
        byArray2[0] = 48;
        byArray2[n2++] = (byte)n3;
        byArray2[n2++] = 2;
        byArray2[n2++] = (byte)n7;
        System.arraycopy(byArray, n5 - n6, byArray2, n2 + n7 - n6, n6);
        n2 += n7;
        byArray2[n2++] = 2;
        byArray2[n2++] = (byte)n8;
        System.arraycopy(byArray, 2 * n5 - n4, byArray2, n2 + n8 - n4, n4);
        return byArray2;
    }

    private ECDSA() {
    }
}

