/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl;

import com.google.crypto.tink.subtle.X25519;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.interfaces.ECPublicKey;
import java.util.Collection;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import macromedia.externals.com.nimbusds.jose_8_2_1.EncryptionMethod;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEAlgorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEHeader;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.AlgorithmSupportMessage;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.ConcatKDF;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.ECDH;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.ECDHCryptoProvider;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.Curve;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.OctetKeyPair;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64URL;

/*
 * Exception performing whole class analysis ignored.
 */
public class ECDH {
    public static AlgorithmMode resolveAlgorithmMode(JWEAlgorithm jWEAlgorithm) throws JOSEException {
        if (jWEAlgorithm.equals((Object)JWEAlgorithm.ECDH_ES)) {
            return AlgorithmMode.DIRECT;
        }
        if (jWEAlgorithm.equals((Object)JWEAlgorithm.ECDH_ES_A128KW) || jWEAlgorithm.equals((Object)JWEAlgorithm.ECDH_ES_A192KW) || jWEAlgorithm.equals((Object)JWEAlgorithm.ECDH_ES_A256KW)) {
            return AlgorithmMode.KW;
        }
        throw new JOSEException(AlgorithmSupportMessage.unsupportedJWEAlgorithm((JWEAlgorithm)jWEAlgorithm, (Collection)ECDHCryptoProvider.SUPPORTED_ALGORITHMS));
    }

    public static int sharedKeyLength(JWEAlgorithm jWEAlgorithm, EncryptionMethod encryptionMethod) throws JOSEException {
        if (jWEAlgorithm.equals((Object)JWEAlgorithm.ECDH_ES)) {
            int n2 = encryptionMethod.cekBitLength();
            if (n2 == 0) {
                throw new JOSEException("Unsupported JWE encryption method " + encryptionMethod);
            }
            return n2;
        }
        if (jWEAlgorithm.equals((Object)JWEAlgorithm.ECDH_ES_A128KW)) {
            return 128;
        }
        if (jWEAlgorithm.equals((Object)JWEAlgorithm.ECDH_ES_A192KW)) {
            return 192;
        }
        if (jWEAlgorithm.equals((Object)JWEAlgorithm.ECDH_ES_A256KW)) {
            return 256;
        }
        throw new JOSEException(AlgorithmSupportMessage.unsupportedJWEAlgorithm((JWEAlgorithm)jWEAlgorithm, (Collection)ECDHCryptoProvider.SUPPORTED_ALGORITHMS));
    }

    public static SecretKey deriveSharedSecret(ECPublicKey eCPublicKey, PrivateKey privateKey, Provider provider) throws JOSEException {
        KeyAgreement keyAgreement;
        try {
            keyAgreement = provider != null ? KeyAgreement.getInstance("ECDH", provider) : KeyAgreement.getInstance("ECDH");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new JOSEException("Couldn't get an ECDH key agreement instance: " + noSuchAlgorithmException.getMessage(), (Throwable)noSuchAlgorithmException);
        }
        try {
            keyAgreement.init(privateKey);
            keyAgreement.doPhase(eCPublicKey, true);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new JOSEException("Invalid key for ECDH key agreement: " + invalidKeyException.getMessage(), (Throwable)invalidKeyException);
        }
        return new SecretKeySpec(keyAgreement.generateSecret(), "AES");
    }

    public static SecretKey deriveSharedSecret(OctetKeyPair octetKeyPair, OctetKeyPair octetKeyPair2) throws JOSEException {
        byte[] byArray;
        if (octetKeyPair.isPrivate()) {
            throw new JOSEException("Expected public key but received OKP with 'd' value");
        }
        if (!Curve.X25519.equals((Object)octetKeyPair.getCurve())) {
            throw new JOSEException("Expected public key OKP with crv=X25519");
        }
        if (!octetKeyPair2.isPrivate()) {
            throw new JOSEException("Expected private key but received OKP without 'd' value");
        }
        if (!Curve.X25519.equals((Object)octetKeyPair2.getCurve())) {
            throw new JOSEException("Expected private key OKP with crv=X25519");
        }
        byte[] byArray2 = octetKeyPair2.getDecodedD();
        byte[] byArray3 = octetKeyPair.getDecodedX();
        try {
            byArray = X25519.computeSharedSecret((byte[])byArray2, (byte[])byArray3);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new JOSEException(invalidKeyException.getMessage(), (Throwable)invalidKeyException);
        }
        return new SecretKeySpec(byArray, "AES");
    }

    public static SecretKey deriveSharedKey(JWEHeader jWEHeader, SecretKey secretKey, ConcatKDF concatKDF) throws JOSEException {
        String string;
        int n2 = ECDH.sharedKeyLength((JWEAlgorithm)jWEHeader.getAlgorithm(), (EncryptionMethod)jWEHeader.getEncryptionMethod());
        AlgorithmMode algorithmMode = ECDH.resolveAlgorithmMode((JWEAlgorithm)jWEHeader.getAlgorithm());
        if (algorithmMode == AlgorithmMode.DIRECT) {
            string = jWEHeader.getEncryptionMethod().getName();
        } else if (algorithmMode == AlgorithmMode.KW) {
            string = jWEHeader.getAlgorithm().getName();
        } else {
            throw new JOSEException("Unsupported JWE ECDH algorithm mode: " + algorithmMode);
        }
        return concatKDF.deriveKey(secretKey, n2, ConcatKDF.encodeDataWithLength((byte[])string.getBytes(Charset.forName("ASCII"))), ConcatKDF.encodeDataWithLength((Base64URL)jWEHeader.getAgreementPartyUInfo()), ConcatKDF.encodeDataWithLength((Base64URL)jWEHeader.getAgreementPartyVInfo()), ConcatKDF.encodeIntData((int)n2), ConcatKDF.encodeNoData());
    }

    private ECDH() {
    }
}

