/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl;

import macromedia.externals.com.nimbusds.jose_8_2_1.CompressionAlgorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEHeader;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.DeflateUtils;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DeflateHelper {
    public static byte[] applyCompression(JWEHeader jWEHeader, byte[] byArray) throws JOSEException {
        CompressionAlgorithm compressionAlgorithm = jWEHeader.getCompressionAlgorithm();
        if (compressionAlgorithm == null) {
            return byArray;
        }
        if (compressionAlgorithm.equals((Object)CompressionAlgorithm.DEF)) {
            try {
                return DeflateUtils.compress((byte[])byArray);
            }
            catch (Exception exception) {
                throw new JOSEException("Couldn't compress plain text: " + exception.getMessage(), (Throwable)exception);
            }
        }
        throw new JOSEException("Unsupported compression algorithm: " + compressionAlgorithm);
    }

    public static byte[] applyDecompression(JWEHeader jWEHeader, byte[] byArray) throws JOSEException {
        CompressionAlgorithm compressionAlgorithm = jWEHeader.getCompressionAlgorithm();
        if (compressionAlgorithm == null) {
            return byArray;
        }
        if (compressionAlgorithm.equals((Object)CompressionAlgorithm.DEF)) {
            try {
                return DeflateUtils.decompress((byte[])byArray);
            }
            catch (Exception exception) {
                throw new JOSEException("Couldn't decompress plain text: " + exception.getMessage(), (Throwable)exception);
            }
        }
        throw new JOSEException("Unsupported compression algorithm: " + compressionAlgorithm);
    }
}

