/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl;

import java.security.Provider;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import macromedia.externals.com.nimbusds.jose_8_2_1.EncryptionMethod;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWECryptoParts;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEHeader;
import macromedia.externals.com.nimbusds.jose_8_2_1.KeyLengthException;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.AAD;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.AESCBC;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.AESGCM;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.AlgorithmSupportMessage;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.AuthenticatedCipherText;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.DeflateHelper;
import macromedia.externals.com.nimbusds.jose_8_2_1.jca.JWEJCAContext;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64URL;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.ByteUtils;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Container;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.IntegerOverflowException;

/*
 * Exception performing whole class analysis ignored.
 */
public class ContentCryptoProvider {
    public static final Set<EncryptionMethod> SUPPORTED_ENCRYPTION_METHODS;
    public static final Map<Integer, Set<EncryptionMethod>> COMPATIBLE_ENCRYPTION_METHODS;

    public static SecretKey generateCEK(EncryptionMethod encryptionMethod, SecureRandom secureRandom) throws JOSEException {
        if (!SUPPORTED_ENCRYPTION_METHODS.contains(encryptionMethod)) {
            throw new JOSEException(AlgorithmSupportMessage.unsupportedEncryptionMethod((EncryptionMethod)encryptionMethod, (Collection)SUPPORTED_ENCRYPTION_METHODS));
        }
        byte[] byArray = new byte[ByteUtils.byteLength((int)encryptionMethod.cekBitLength())];
        secureRandom.nextBytes(byArray);
        return new SecretKeySpec(byArray, "AES");
    }

    private static void checkCEKLength(SecretKey secretKey, EncryptionMethod encryptionMethod) throws KeyLengthException {
        try {
            if (encryptionMethod.cekBitLength() != ByteUtils.safeBitLength((byte[])secretKey.getEncoded())) {
                throw new KeyLengthException("The Content Encryption Key (CEK) length for " + encryptionMethod + " must be " + encryptionMethod.cekBitLength() + " bits");
            }
        }
        catch (IntegerOverflowException integerOverflowException) {
            throw new KeyLengthException("The Content Encryption Key (CEK) is too long: " + integerOverflowException.getMessage());
        }
    }

    public static JWECryptoParts encrypt(JWEHeader jWEHeader, byte[] byArray, SecretKey secretKey, Base64URL base64URL, JWEJCAContext jWEJCAContext) throws JOSEException {
        AuthenticatedCipherText authenticatedCipherText;
        byte[] byArray2;
        ContentCryptoProvider.checkCEKLength((SecretKey)secretKey, (EncryptionMethod)jWEHeader.getEncryptionMethod());
        byte[] byArray3 = DeflateHelper.applyCompression((JWEHeader)jWEHeader, (byte[])byArray);
        byte[] byArray4 = AAD.compute((JWEHeader)jWEHeader);
        if (jWEHeader.getEncryptionMethod().equals((Object)EncryptionMethod.A128CBC_HS256) || jWEHeader.getEncryptionMethod().equals((Object)EncryptionMethod.A192CBC_HS384) || jWEHeader.getEncryptionMethod().equals((Object)EncryptionMethod.A256CBC_HS512)) {
            byArray2 = AESCBC.generateIV((SecureRandom)jWEJCAContext.getSecureRandom());
            authenticatedCipherText = AESCBC.encryptAuthenticated((SecretKey)secretKey, (byte[])byArray2, (byte[])byArray3, (byte[])byArray4, (Provider)jWEJCAContext.getContentEncryptionProvider(), (Provider)jWEJCAContext.getMACProvider());
        } else if (jWEHeader.getEncryptionMethod().equals((Object)EncryptionMethod.A128GCM) || jWEHeader.getEncryptionMethod().equals((Object)EncryptionMethod.A192GCM) || jWEHeader.getEncryptionMethod().equals((Object)EncryptionMethod.A256GCM)) {
            Container container = new Container((Object)AESGCM.generateIV((SecureRandom)jWEJCAContext.getSecureRandom()));
            authenticatedCipherText = AESGCM.encrypt((SecretKey)secretKey, (Container)container, (byte[])byArray3, (byte[])byArray4, (Provider)jWEJCAContext.getContentEncryptionProvider());
            byArray2 = (byte[])container.get();
        } else if (jWEHeader.getEncryptionMethod().equals((Object)EncryptionMethod.A128CBC_HS256_DEPRECATED) || jWEHeader.getEncryptionMethod().equals((Object)EncryptionMethod.A256CBC_HS512_DEPRECATED)) {
            byArray2 = AESCBC.generateIV((SecureRandom)jWEJCAContext.getSecureRandom());
            authenticatedCipherText = AESCBC.encryptWithConcatKDF((JWEHeader)jWEHeader, (SecretKey)secretKey, (Base64URL)base64URL, (byte[])byArray2, (byte[])byArray3, (Provider)jWEJCAContext.getContentEncryptionProvider(), (Provider)jWEJCAContext.getMACProvider());
        } else {
            throw new JOSEException(AlgorithmSupportMessage.unsupportedEncryptionMethod((EncryptionMethod)jWEHeader.getEncryptionMethod(), (Collection)SUPPORTED_ENCRYPTION_METHODS));
        }
        return new JWECryptoParts(jWEHeader, base64URL, Base64URL.encode((byte[])byArray2), Base64URL.encode((byte[])authenticatedCipherText.getCipherText()), Base64URL.encode((byte[])authenticatedCipherText.getAuthenticationTag()));
    }

    public static byte[] decrypt(JWEHeader jWEHeader, Base64URL base64URL, Base64URL base64URL2, Base64URL base64URL3, Base64URL base64URL4, SecretKey secretKey, JWEJCAContext jWEJCAContext) throws JOSEException {
        byte[] byArray;
        ContentCryptoProvider.checkCEKLength((SecretKey)secretKey, (EncryptionMethod)jWEHeader.getEncryptionMethod());
        byte[] byArray2 = AAD.compute((JWEHeader)jWEHeader);
        if (jWEHeader.getEncryptionMethod().equals((Object)EncryptionMethod.A128CBC_HS256) || jWEHeader.getEncryptionMethod().equals((Object)EncryptionMethod.A192CBC_HS384) || jWEHeader.getEncryptionMethod().equals((Object)EncryptionMethod.A256CBC_HS512)) {
            byArray = AESCBC.decryptAuthenticated((SecretKey)secretKey, (byte[])base64URL2.decode(), (byte[])base64URL3.decode(), (byte[])byArray2, (byte[])base64URL4.decode(), (Provider)jWEJCAContext.getContentEncryptionProvider(), (Provider)jWEJCAContext.getMACProvider());
        } else if (jWEHeader.getEncryptionMethod().equals((Object)EncryptionMethod.A128GCM) || jWEHeader.getEncryptionMethod().equals((Object)EncryptionMethod.A192GCM) || jWEHeader.getEncryptionMethod().equals((Object)EncryptionMethod.A256GCM)) {
            byArray = AESGCM.decrypt((SecretKey)secretKey, (byte[])base64URL2.decode(), (byte[])base64URL3.decode(), (byte[])byArray2, (byte[])base64URL4.decode(), (Provider)jWEJCAContext.getContentEncryptionProvider());
        } else if (jWEHeader.getEncryptionMethod().equals((Object)EncryptionMethod.A128CBC_HS256_DEPRECATED) || jWEHeader.getEncryptionMethod().equals((Object)EncryptionMethod.A256CBC_HS512_DEPRECATED)) {
            byArray = AESCBC.decryptWithConcatKDF((JWEHeader)jWEHeader, (SecretKey)secretKey, (Base64URL)base64URL, (Base64URL)base64URL2, (Base64URL)base64URL3, (Base64URL)base64URL4, (Provider)jWEJCAContext.getContentEncryptionProvider(), (Provider)jWEJCAContext.getMACProvider());
        } else {
            throw new JOSEException(AlgorithmSupportMessage.unsupportedEncryptionMethod((EncryptionMethod)jWEHeader.getEncryptionMethod(), (Collection)SUPPORTED_ENCRYPTION_METHODS));
        }
        return DeflateHelper.applyDecompression((JWEHeader)jWEHeader, (byte[])byArray);
    }

    static {
        LinkedHashSet<EncryptionMethod> linkedHashSet = new LinkedHashSet<EncryptionMethod>();
        linkedHashSet.add(EncryptionMethod.A128CBC_HS256);
        linkedHashSet.add(EncryptionMethod.A192CBC_HS384);
        linkedHashSet.add(EncryptionMethod.A256CBC_HS512);
        linkedHashSet.add(EncryptionMethod.A128GCM);
        linkedHashSet.add(EncryptionMethod.A192GCM);
        linkedHashSet.add(EncryptionMethod.A256GCM);
        linkedHashSet.add(EncryptionMethod.A128CBC_HS256_DEPRECATED);
        linkedHashSet.add(EncryptionMethod.A256CBC_HS512_DEPRECATED);
        SUPPORTED_ENCRYPTION_METHODS = Collections.unmodifiableSet(linkedHashSet);
        HashMap hashMap = new HashMap();
        HashSet<EncryptionMethod> hashSet = new HashSet<EncryptionMethod>();
        HashSet<EncryptionMethod> hashSet2 = new HashSet<EncryptionMethod>();
        HashSet<EncryptionMethod> hashSet3 = new HashSet<EncryptionMethod>();
        HashSet<EncryptionMethod> hashSet4 = new HashSet<EncryptionMethod>();
        HashSet<EncryptionMethod> hashSet5 = new HashSet<EncryptionMethod>();
        hashSet.add(EncryptionMethod.A128GCM);
        hashSet2.add(EncryptionMethod.A192GCM);
        hashSet3.add(EncryptionMethod.A256GCM);
        hashSet3.add(EncryptionMethod.A128CBC_HS256);
        hashSet3.add(EncryptionMethod.A128CBC_HS256_DEPRECATED);
        hashSet4.add(EncryptionMethod.A192CBC_HS384);
        hashSet5.add(EncryptionMethod.A256CBC_HS512);
        hashSet5.add(EncryptionMethod.A256CBC_HS512_DEPRECATED);
        hashMap.put(128, Collections.unmodifiableSet(hashSet));
        hashMap.put(192, Collections.unmodifiableSet(hashSet2));
        hashMap.put(256, Collections.unmodifiableSet(hashSet3));
        hashMap.put(384, Collections.unmodifiableSet(hashSet4));
        hashMap.put(512, Collections.unmodifiableSet(hashSet5));
        COMPATIBLE_ENCRYPTION_METHODS = Collections.unmodifiableMap(hashMap);
    }
}

