/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl;

import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import macromedia.externals.com.nimbusds.jose_8_2_1.KeyLengthException;
import net.jcip.annotations.Immutable;

@Immutable
public final class CompositeKey {
    private final SecretKey inputKey;
    private final SecretKey macKey;
    private final SecretKey encKey;
    private final int truncatedMacLength;

    public CompositeKey(SecretKey secretKey) throws KeyLengthException {
        this.inputKey = secretKey;
        byte[] byArray = secretKey.getEncoded();
        if (byArray.length == 32) {
            this.macKey = new SecretKeySpec(byArray, 0, 16, "HMACSHA256");
            this.encKey = new SecretKeySpec(byArray, 16, 16, "AES");
            this.truncatedMacLength = 16;
        } else if (byArray.length == 48) {
            this.macKey = new SecretKeySpec(byArray, 0, 24, "HMACSHA384");
            this.encKey = new SecretKeySpec(byArray, 24, 24, "AES");
            this.truncatedMacLength = 24;
        } else if (byArray.length == 64) {
            this.macKey = new SecretKeySpec(byArray, 0, 32, "HMACSHA512");
            this.encKey = new SecretKeySpec(byArray, 32, 32, "AES");
            this.truncatedMacLength = 32;
        } else {
            throw new KeyLengthException("Unsupported AES/CBC/PKCS5Padding/HMAC-SHA2 key length, must be 256, 384 or 512 bits");
        }
    }

    public SecretKey getInputKey() {
        return this.inputKey;
    }

    public SecretKey getMACKey() {
        return this.macKey;
    }

    public int getTruncatedMACByteLength() {
        return this.truncatedMacLength;
    }

    public SecretKey getAESKey() {
        return this.encKey;
    }
}

