/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.crypto.factories;

import java.security.Key;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.crypto.SecretKey;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSAlgorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSHeader;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSVerifier;
import macromedia.externals.com.nimbusds.jose_8_2_1.KeyTypeException;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.ECDSAVerifier;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.MACVerifier;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.RSASSAVerifier;
import macromedia.externals.com.nimbusds.jose_8_2_1.jca.JCAContext;
import macromedia.externals.com.nimbusds.jose_8_2_1.proc.JWSVerifierFactory;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DefaultJWSVerifierFactory
implements JWSVerifierFactory {
    public static final Set<JWSAlgorithm> SUPPORTED_ALGORITHMS;
    private final JCAContext jcaContext = new JCAContext();

    public Set<JWSAlgorithm> supportedJWSAlgorithms() {
        return SUPPORTED_ALGORITHMS;
    }

    public JCAContext getJCAContext() {
        return this.jcaContext;
    }

    public JWSVerifier createJWSVerifier(JWSHeader jWSHeader, Key key) throws JOSEException {
        MACVerifier mACVerifier;
        if (MACVerifier.SUPPORTED_ALGORITHMS.contains(jWSHeader.getAlgorithm())) {
            if (!(key instanceof SecretKey)) {
                throw new KeyTypeException(SecretKey.class);
            }
            SecretKey secretKey = (SecretKey)key;
            mACVerifier = new MACVerifier(secretKey);
        } else if (RSASSAVerifier.SUPPORTED_ALGORITHMS.contains(jWSHeader.getAlgorithm())) {
            if (!(key instanceof RSAPublicKey)) {
                throw new KeyTypeException(RSAPublicKey.class);
            }
            RSAPublicKey rSAPublicKey = (RSAPublicKey)key;
            mACVerifier = new RSASSAVerifier(rSAPublicKey);
        } else if (ECDSAVerifier.SUPPORTED_ALGORITHMS.contains(jWSHeader.getAlgorithm())) {
            if (!(key instanceof ECPublicKey)) {
                throw new KeyTypeException(ECPublicKey.class);
            }
            ECPublicKey eCPublicKey = (ECPublicKey)key;
            mACVerifier = new ECDSAVerifier(eCPublicKey);
        } else {
            throw new JOSEException("Unsupported JWS algorithm: " + jWSHeader.getAlgorithm());
        }
        mACVerifier.getJCAContext().setSecureRandom(this.jcaContext.getSecureRandom());
        mACVerifier.getJCAContext().setProvider(this.jcaContext.getProvider());
        return mACVerifier;
    }

    static {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        linkedHashSet.addAll(MACVerifier.SUPPORTED_ALGORITHMS);
        linkedHashSet.addAll(RSASSAVerifier.SUPPORTED_ALGORITHMS);
        linkedHashSet.addAll(ECDSAVerifier.SUPPORTED_ALGORITHMS);
        SUPPORTED_ALGORITHMS = Collections.unmodifiableSet(linkedHashSet);
    }
}

