/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.crypto.factories;

import java.security.Key;
import java.security.PrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.crypto.SecretKey;
import macromedia.externals.com.nimbusds.jose_8_2_1.Algorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.EncryptionMethod;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEAlgorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEDecrypter;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEHeader;
import macromedia.externals.com.nimbusds.jose_8_2_1.KeyLengthException;
import macromedia.externals.com.nimbusds.jose_8_2_1.KeyTypeException;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.AESDecrypter;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.DirectDecrypter;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.ECDHDecrypter;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.PasswordBasedDecrypter;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.RSADecrypter;
import macromedia.externals.com.nimbusds.jose_8_2_1.jca.JWEJCAContext;
import macromedia.externals.com.nimbusds.jose_8_2_1.proc.JWEDecrypterFactory;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DefaultJWEDecrypterFactory
implements JWEDecrypterFactory {
    public static final Set<JWEAlgorithm> SUPPORTED_ALGORITHMS;
    public static final Set<EncryptionMethod> SUPPORTED_ENCRYPTION_METHODS;
    private final JWEJCAContext jcaContext = new JWEJCAContext();

    public Set<JWEAlgorithm> supportedJWEAlgorithms() {
        return SUPPORTED_ALGORITHMS;
    }

    public Set<EncryptionMethod> supportedEncryptionMethods() {
        return SUPPORTED_ENCRYPTION_METHODS;
    }

    public JWEJCAContext getJCAContext() {
        return this.jcaContext;
    }

    public JWEDecrypter createJWEDecrypter(JWEHeader jWEHeader, Key key) throws JOSEException {
        RSADecrypter rSADecrypter;
        if (RSADecrypter.SUPPORTED_ALGORITHMS.contains(jWEHeader.getAlgorithm()) && RSADecrypter.SUPPORTED_ENCRYPTION_METHODS.contains(jWEHeader.getEncryptionMethod())) {
            if (!(key instanceof RSAPrivateKey)) {
                throw new KeyTypeException(RSAPrivateKey.class);
            }
            RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)key;
            rSADecrypter = new RSADecrypter((PrivateKey)rSAPrivateKey);
        } else if (ECDHDecrypter.SUPPORTED_ALGORITHMS.contains(jWEHeader.getAlgorithm()) && ECDHDecrypter.SUPPORTED_ENCRYPTION_METHODS.contains(jWEHeader.getEncryptionMethod())) {
            if (!(key instanceof ECPrivateKey)) {
                throw new KeyTypeException(ECPrivateKey.class);
            }
            ECPrivateKey eCPrivateKey = (ECPrivateKey)key;
            rSADecrypter = new ECDHDecrypter(eCPrivateKey);
        } else if (DirectDecrypter.SUPPORTED_ALGORITHMS.contains(jWEHeader.getAlgorithm()) && DirectDecrypter.SUPPORTED_ENCRYPTION_METHODS.contains(jWEHeader.getEncryptionMethod())) {
            if (!(key instanceof SecretKey)) {
                throw new KeyTypeException(SecretKey.class);
            }
            SecretKey secretKey = (SecretKey)key;
            DirectDecrypter directDecrypter = new DirectDecrypter(secretKey);
            if (!directDecrypter.supportedEncryptionMethods().contains(jWEHeader.getEncryptionMethod())) {
                throw new KeyLengthException(jWEHeader.getEncryptionMethod().cekBitLength(), (Algorithm)jWEHeader.getEncryptionMethod());
            }
            rSADecrypter = directDecrypter;
        } else if (AESDecrypter.SUPPORTED_ALGORITHMS.contains(jWEHeader.getAlgorithm()) && AESDecrypter.SUPPORTED_ENCRYPTION_METHODS.contains(jWEHeader.getEncryptionMethod())) {
            if (!(key instanceof SecretKey)) {
                throw new KeyTypeException(SecretKey.class);
            }
            SecretKey secretKey = (SecretKey)key;
            AESDecrypter aESDecrypter = new AESDecrypter(secretKey);
            if (!aESDecrypter.supportedJWEAlgorithms().contains(jWEHeader.getAlgorithm())) {
                throw new KeyLengthException((Algorithm)jWEHeader.getAlgorithm());
            }
            rSADecrypter = aESDecrypter;
        } else if (PasswordBasedDecrypter.SUPPORTED_ALGORITHMS.contains(jWEHeader.getAlgorithm()) && PasswordBasedDecrypter.SUPPORTED_ENCRYPTION_METHODS.contains(jWEHeader.getEncryptionMethod())) {
            if (!(key instanceof SecretKey)) {
                throw new KeyTypeException(SecretKey.class);
            }
            byte[] byArray = key.getEncoded();
            rSADecrypter = new PasswordBasedDecrypter(byArray);
        } else {
            throw new JOSEException("Unsupported JWE algorithm or encryption method");
        }
        ((JWEJCAContext)rSADecrypter.getJCAContext()).setSecureRandom(this.jcaContext.getSecureRandom());
        ((JWEJCAContext)rSADecrypter.getJCAContext()).setProvider(this.jcaContext.getProvider());
        ((JWEJCAContext)rSADecrypter.getJCAContext()).setKeyEncryptionProvider(this.jcaContext.getKeyEncryptionProvider());
        ((JWEJCAContext)rSADecrypter.getJCAContext()).setMACProvider(this.jcaContext.getMACProvider());
        ((JWEJCAContext)rSADecrypter.getJCAContext()).setContentEncryptionProvider(this.jcaContext.getContentEncryptionProvider());
        return rSADecrypter;
    }

    static {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        linkedHashSet.addAll(RSADecrypter.SUPPORTED_ALGORITHMS);
        linkedHashSet.addAll(ECDHDecrypter.SUPPORTED_ALGORITHMS);
        linkedHashSet.addAll(DirectDecrypter.SUPPORTED_ALGORITHMS);
        linkedHashSet.addAll(AESDecrypter.SUPPORTED_ALGORITHMS);
        linkedHashSet.addAll(PasswordBasedDecrypter.SUPPORTED_ALGORITHMS);
        SUPPORTED_ALGORITHMS = Collections.unmodifiableSet(linkedHashSet);
        LinkedHashSet linkedHashSet2 = new LinkedHashSet();
        linkedHashSet2.addAll(RSADecrypter.SUPPORTED_ENCRYPTION_METHODS);
        linkedHashSet2.addAll(ECDHDecrypter.SUPPORTED_ENCRYPTION_METHODS);
        linkedHashSet2.addAll(DirectDecrypter.SUPPORTED_ENCRYPTION_METHODS);
        linkedHashSet2.addAll(AESDecrypter.SUPPORTED_ENCRYPTION_METHODS);
        linkedHashSet2.addAll(PasswordBasedDecrypter.SUPPORTED_ENCRYPTION_METHODS);
        SUPPORTED_ENCRYPTION_METHODS = Collections.unmodifiableSet(linkedHashSet2);
    }
}

