/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.crypto;

import java.util.Collections;
import java.util.Set;
import javax.crypto.SecretKey;
import macromedia.externals.com.nimbusds.jose_8_2_1.CriticalHeaderParamsAware;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEDecrypter;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEHeader;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.CriticalHeaderParamsDeferral;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.ECDH;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.ECDHCryptoProvider;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.Curve;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.OctetKeyPair;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64URL;

public class X25519Decrypter
extends ECDHCryptoProvider
implements CriticalHeaderParamsAware,
JWEDecrypter {
    private final OctetKeyPair privateKey;
    private final CriticalHeaderParamsDeferral critPolicy = new CriticalHeaderParamsDeferral();

    public X25519Decrypter(OctetKeyPair octetKeyPair) throws JOSEException {
        this(octetKeyPair, null);
    }

    public X25519Decrypter(OctetKeyPair octetKeyPair, Set<String> set) throws JOSEException {
        super(octetKeyPair.getCurve());
        if (!Curve.X25519.equals((Object)octetKeyPair.getCurve())) {
            throw new JOSEException("X25519Decrypter only supports OctetKeyPairs with crv=X25519");
        }
        if (!octetKeyPair.isPrivate()) {
            throw new JOSEException("The OctetKeyPair doesn't contain a private part");
        }
        this.privateKey = octetKeyPair;
        this.critPolicy.setDeferredCriticalHeaderParams(set);
    }

    public Set<Curve> supportedEllipticCurves() {
        return Collections.singleton(Curve.X25519);
    }

    public OctetKeyPair getPrivateKey() {
        return this.privateKey;
    }

    public Set<String> getProcessedCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    public Set<String> getDeferredCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    public byte[] decrypt(JWEHeader jWEHeader, Base64URL base64URL, Base64URL base64URL2, Base64URL base64URL3, Base64URL base64URL4) throws JOSEException {
        this.critPolicy.ensureHeaderPasses(jWEHeader);
        OctetKeyPair octetKeyPair = (OctetKeyPair)jWEHeader.getEphemeralPublicKey();
        if (octetKeyPair == null) {
            throw new JOSEException("Missing ephemeral public key \"epk\" JWE header parameter");
        }
        if (!this.privateKey.getCurve().equals((Object)octetKeyPair.getCurve())) {
            throw new JOSEException("Curve of ephemeral public key does not match curve of private key");
        }
        SecretKey secretKey = ECDH.deriveSharedSecret((OctetKeyPair)octetKeyPair, (OctetKeyPair)this.privateKey);
        return this.decryptWithZ(jWEHeader, secretKey, base64URL, base64URL2, base64URL3, base64URL4);
    }
}

