/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.crypto;

import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Set;
import javax.crypto.SecretKey;
import macromedia.externals.com.nimbusds.jose_8_2_1.CriticalHeaderParamsAware;
import macromedia.externals.com.nimbusds.jose_8_2_1.EncryptionMethod;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEAlgorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEDecrypter;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEHeader;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.AlgorithmSupportMessage;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.ContentCryptoProvider;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.CriticalHeaderParamsDeferral;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.RSA1_5;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.RSACryptoProvider;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.RSAKeyUtils;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.RSA_OAEP;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.RSA_OAEP_256;
import macromedia.externals.com.nimbusds.jose_8_2_1.jca.JWEJCAContext;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.RSAKey;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64URL;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class RSADecrypter
extends RSACryptoProvider
implements CriticalHeaderParamsAware,
JWEDecrypter {
    private final CriticalHeaderParamsDeferral critPolicy = new CriticalHeaderParamsDeferral();
    private final PrivateKey privateKey;
    private Exception cekDecryptionException;

    public RSADecrypter(PrivateKey privateKey) {
        this(privateKey, null, false);
    }

    public RSADecrypter(RSAKey rSAKey) throws JOSEException {
        this(RSAKeyUtils.toRSAPrivateKey((RSAKey)rSAKey));
    }

    public RSADecrypter(PrivateKey privateKey, Set<String> set) {
        this(privateKey, set, false);
    }

    public RSADecrypter(PrivateKey privateKey, Set<String> set, boolean bl2) {
        int n2;
        if (!privateKey.getAlgorithm().equalsIgnoreCase("RSA")) {
            throw new IllegalArgumentException("The private key algorithm must be RSA");
        }
        if (!bl2 && (n2 = RSAKeyUtils.keyBitLength((PrivateKey)privateKey)) > 0 && n2 < 2048) {
            throw new IllegalArgumentException("The RSA key size must be at least 2048 bits");
        }
        this.privateKey = privateKey;
        this.critPolicy.setDeferredCriticalHeaderParams(set);
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public Set<String> getProcessedCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    public Set<String> getDeferredCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    public byte[] decrypt(JWEHeader jWEHeader, Base64URL base64URL, Base64URL base64URL2, Base64URL base64URL3, Base64URL base64URL4) throws JOSEException {
        SecretKey secretKey;
        if (base64URL == null) {
            throw new JOSEException("Missing JWE encrypted key");
        }
        if (base64URL2 == null) {
            throw new JOSEException("Missing JWE initialization vector (IV)");
        }
        if (base64URL4 == null) {
            throw new JOSEException("Missing JWE authentication tag");
        }
        this.critPolicy.ensureHeaderPasses(jWEHeader);
        JWEAlgorithm jWEAlgorithm = jWEHeader.getAlgorithm();
        if (jWEAlgorithm.equals((Object)JWEAlgorithm.RSA1_5)) {
            int n2 = jWEHeader.getEncryptionMethod().cekBitLength();
            SecretKey secretKey2 = ContentCryptoProvider.generateCEK((EncryptionMethod)jWEHeader.getEncryptionMethod(), (SecureRandom)this.getJCAContext().getSecureRandom());
            try {
                secretKey = RSA1_5.decryptCEK((PrivateKey)this.privateKey, (byte[])base64URL.decode(), (int)n2, (Provider)this.getJCAContext().getKeyEncryptionProvider());
                if (secretKey == null) {
                    secretKey = secretKey2;
                }
            }
            catch (Exception exception) {
                this.cekDecryptionException = exception;
                secretKey = secretKey2;
            }
            this.cekDecryptionException = null;
        } else if (jWEAlgorithm.equals((Object)JWEAlgorithm.RSA_OAEP)) {
            secretKey = RSA_OAEP.decryptCEK((PrivateKey)this.privateKey, (byte[])base64URL.decode(), (Provider)this.getJCAContext().getKeyEncryptionProvider());
        } else if (jWEAlgorithm.equals((Object)JWEAlgorithm.RSA_OAEP_256)) {
            secretKey = RSA_OAEP_256.decryptCEK((PrivateKey)this.privateKey, (byte[])base64URL.decode(), (Provider)this.getJCAContext().getKeyEncryptionProvider());
        } else {
            throw new JOSEException(AlgorithmSupportMessage.unsupportedJWEAlgorithm((JWEAlgorithm)jWEAlgorithm, (Collection)SUPPORTED_ALGORITHMS));
        }
        return ContentCryptoProvider.decrypt((JWEHeader)jWEHeader, (Base64URL)base64URL, (Base64URL)base64URL2, (Base64URL)base64URL3, (Base64URL)base64URL4, (SecretKey)secretKey, (JWEJCAContext)this.getJCAContext());
    }

    public Exception getCEKDecryptionException() {
        return this.cekDecryptionException;
    }
}

