/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.crypto;

import java.security.Provider;
import java.util.Set;
import javax.crypto.SecretKey;
import macromedia.externals.com.nimbusds.jose_8_2_1.CriticalHeaderParamsAware;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEAlgorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEDecrypter;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEHeader;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.AESKW;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.ContentCryptoProvider;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.CriticalHeaderParamsDeferral;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.PBKDF2;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.PRFParams;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.PasswordBasedCryptoProvider;
import macromedia.externals.com.nimbusds.jose_8_2_1.jca.JWEJCAContext;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64URL;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.StandardCharset;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class PasswordBasedDecrypter
extends PasswordBasedCryptoProvider
implements CriticalHeaderParamsAware,
JWEDecrypter {
    private final CriticalHeaderParamsDeferral critPolicy = new CriticalHeaderParamsDeferral();

    public PasswordBasedDecrypter(byte[] byArray) {
        super(byArray);
    }

    public PasswordBasedDecrypter(String string) {
        super(string.getBytes(StandardCharset.UTF_8));
    }

    public Set<String> getProcessedCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    public Set<String> getDeferredCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    public byte[] decrypt(JWEHeader jWEHeader, Base64URL base64URL, Base64URL base64URL2, Base64URL base64URL3, Base64URL base64URL4) throws JOSEException {
        if (base64URL == null) {
            throw new JOSEException("Missing JWE encrypted key");
        }
        if (base64URL2 == null) {
            throw new JOSEException("Missing JWE initialization vector (IV)");
        }
        if (base64URL4 == null) {
            throw new JOSEException("Missing JWE authentication tag");
        }
        if (jWEHeader.getPBES2Salt() == null) {
            throw new JOSEException("Missing JWE \"p2s\" header parameter");
        }
        byte[] byArray = jWEHeader.getPBES2Salt().decode();
        if (jWEHeader.getPBES2Count() < 1) {
            throw new JOSEException("Missing JWE \"p2c\" header parameter");
        }
        int n2 = jWEHeader.getPBES2Count();
        this.critPolicy.ensureHeaderPasses(jWEHeader);
        JWEAlgorithm jWEAlgorithm = jWEHeader.getAlgorithm();
        byte[] byArray2 = PBKDF2.formatSalt((JWEAlgorithm)jWEAlgorithm, (byte[])byArray);
        PRFParams pRFParams = PRFParams.resolve((JWEAlgorithm)jWEAlgorithm, (Provider)this.getJCAContext().getMACProvider());
        SecretKey secretKey = PBKDF2.deriveKey((byte[])this.getPassword(), (byte[])byArray2, (int)n2, (PRFParams)pRFParams);
        SecretKey secretKey2 = AESKW.unwrapCEK((SecretKey)secretKey, (byte[])base64URL.decode(), (Provider)this.getJCAContext().getKeyEncryptionProvider());
        return ContentCryptoProvider.decrypt((JWEHeader)jWEHeader, (Base64URL)base64URL, (Base64URL)base64URL2, (Base64URL)base64URL3, (Base64URL)base64URL4, (SecretKey)secretKey2, (JWEJCAContext)this.getJCAContext());
    }
}

