/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.crypto;

import com.google.crypto.tink.subtle.Ed25519Verify;
import java.security.GeneralSecurityException;
import java.util.Set;
import macromedia.externals.com.nimbusds.jose_8_2_1.CriticalHeaderParamsAware;
import macromedia.externals.com.nimbusds.jose_8_2_1.Header;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSAlgorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSHeader;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSVerifier;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.CriticalHeaderParamsDeferral;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.EdDSAProvider;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.Curve;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.OctetKeyPair;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64URL;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class Ed25519Verifier
extends EdDSAProvider
implements CriticalHeaderParamsAware,
JWSVerifier {
    private final CriticalHeaderParamsDeferral critPolicy = new CriticalHeaderParamsDeferral();
    private final OctetKeyPair publicKey;
    private final Ed25519Verify tinkVerifier;

    public Ed25519Verifier(OctetKeyPair octetKeyPair) throws JOSEException {
        this(octetKeyPair, null);
    }

    public Ed25519Verifier(OctetKeyPair octetKeyPair, Set<String> set) throws JOSEException {
        if (!Curve.Ed25519.equals((Object)octetKeyPair.getCurve())) {
            throw new JOSEException("Ed25519Verifier only supports OctetKeyPairs with crv=Ed25519");
        }
        if (octetKeyPair.isPrivate()) {
            throw new JOSEException("Ed25519Verifier requires a public key, use OctetKeyPair.toPublicJWK()");
        }
        this.publicKey = octetKeyPair;
        this.tinkVerifier = new Ed25519Verify(octetKeyPair.getDecodedX());
        this.critPolicy.setDeferredCriticalHeaderParams(set);
    }

    public OctetKeyPair getPublicKey() {
        return this.publicKey;
    }

    public Set<String> getProcessedCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    public Set<String> getDeferredCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    public boolean verify(JWSHeader jWSHeader, byte[] byArray, Base64URL base64URL) throws JOSEException {
        JWSAlgorithm jWSAlgorithm = jWSHeader.getAlgorithm();
        if (!JWSAlgorithm.EdDSA.equals((Object)jWSAlgorithm)) {
            throw new JOSEException("Ed25519Verifier requires alg=EdDSA in JWSHeader");
        }
        if (!this.critPolicy.headerPasses((Header)jWSHeader)) {
            return false;
        }
        byte[] byArray2 = base64URL.decode();
        try {
            this.tinkVerifier.verify(byArray2, byArray);
            return true;
        }
        catch (GeneralSecurityException generalSecurityException) {
            return false;
        }
    }
}

