/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.crypto;

import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECKey;
import java.security.interfaces.ECPrivateKey;
import java.util.Collection;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSAlgorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSHeader;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSSigner;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.AlgorithmSupportMessage;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.ECDSA;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.ECDSAProvider;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.Curve;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64URL;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class ECDSASigner
extends ECDSAProvider
implements JWSSigner {
    private final PrivateKey privateKey;

    public ECDSASigner(ECPrivateKey eCPrivateKey) throws JOSEException {
        super(ECDSA.resolveAlgorithm((ECKey)eCPrivateKey));
        this.privateKey = eCPrivateKey;
    }

    public ECDSASigner(PrivateKey privateKey, Curve curve) throws JOSEException {
        super(ECDSA.resolveAlgorithm((Curve)curve));
        if (!"EC".equalsIgnoreCase(privateKey.getAlgorithm())) {
            throw new IllegalArgumentException("The private key algorithm must be EC");
        }
        this.privateKey = privateKey;
    }

    public ECDSASigner(macromedia.externals.com.nimbusds.jose_8_2_1.jwk.ECKey eCKey) throws JOSEException {
        super(ECDSA.resolveAlgorithm((Curve)eCKey.getCurve()));
        if (!eCKey.isPrivate()) {
            throw new JOSEException("The EC JWK doesn't contain a private part");
        }
        this.privateKey = eCKey.toPrivateKey();
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public Base64URL sign(JWSHeader jWSHeader, byte[] byArray) throws JOSEException {
        byte[] byArray2;
        JWSAlgorithm jWSAlgorithm = jWSHeader.getAlgorithm();
        if (!this.supportedJWSAlgorithms().contains(jWSAlgorithm)) {
            throw new JOSEException(AlgorithmSupportMessage.unsupportedJWSAlgorithm((JWSAlgorithm)jWSAlgorithm, (Collection)this.supportedJWSAlgorithms()));
        }
        try {
            Signature signature = ECDSA.getSignerAndVerifier((JWSAlgorithm)jWSAlgorithm, (Provider)this.getJCAContext().getProvider());
            signature.initSign(this.privateKey, this.getJCAContext().getSecureRandom());
            signature.update(byArray);
            byArray2 = signature.sign();
        }
        catch (InvalidKeyException | SignatureException generalSecurityException) {
            throw new JOSEException(generalSecurityException.getMessage(), (Throwable)generalSecurityException);
        }
        int n2 = ECDSA.getSignatureByteArrayLength((JWSAlgorithm)jWSHeader.getAlgorithm());
        byte[] byArray3 = ECDSA.transcodeSignatureToConcat((byte[])byArray2, (int)n2);
        return Base64URL.encode((byte[])byArray3);
    }
}

