/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.crypto;

import java.util.Collection;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import macromedia.externals.com.nimbusds.jose_8_2_1.Algorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.EncryptionMethod;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEAlgorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWECryptoParts;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEEncrypter;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEHeader;
import macromedia.externals.com.nimbusds.jose_8_2_1.KeyLengthException;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.AlgorithmSupportMessage;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.ContentCryptoProvider;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.DirectCryptoProvider;
import macromedia.externals.com.nimbusds.jose_8_2_1.jca.JWEJCAContext;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.OctetSequenceKey;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64URL;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.ByteUtils;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DirectEncrypter
extends DirectCryptoProvider
implements JWEEncrypter {
    public DirectEncrypter(SecretKey secretKey) throws KeyLengthException {
        super(secretKey);
    }

    public DirectEncrypter(byte[] byArray) throws KeyLengthException {
        this((SecretKey)new SecretKeySpec(byArray, "AES"));
    }

    public DirectEncrypter(OctetSequenceKey octetSequenceKey) throws KeyLengthException {
        this(octetSequenceKey.toSecretKey("AES"));
    }

    public JWECryptoParts encrypt(JWEHeader jWEHeader, byte[] byArray) throws JOSEException {
        JWEAlgorithm jWEAlgorithm = jWEHeader.getAlgorithm();
        if (!jWEAlgorithm.equals((Object)JWEAlgorithm.DIR)) {
            throw new JOSEException(AlgorithmSupportMessage.unsupportedJWEAlgorithm((JWEAlgorithm)jWEAlgorithm, (Collection)SUPPORTED_ALGORITHMS));
        }
        EncryptionMethod encryptionMethod = jWEHeader.getEncryptionMethod();
        if (encryptionMethod.cekBitLength() != ByteUtils.safeBitLength((byte[])this.getKey().getEncoded())) {
            throw new KeyLengthException(encryptionMethod.cekBitLength(), (Algorithm)encryptionMethod);
        }
        Base64URL base64URL = null;
        return ContentCryptoProvider.encrypt((JWEHeader)jWEHeader, (byte[])byArray, (SecretKey)this.getKey(), base64URL, (JWEJCAContext)this.getJCAContext());
    }
}

