/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.crypto;

import java.security.Provider;
import java.security.SecureRandom;
import java.util.Collection;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import macromedia.externals.com.nimbusds.jose_8_2_1.EncryptionMethod;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEAlgorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWECryptoParts;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEEncrypter;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEHeader;
import macromedia.externals.com.nimbusds.jose_8_2_1.KeyLengthException;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.AESEncrypter;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.AESCryptoProvider;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.AESGCM;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.AESGCMKW;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.AESKW;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.AlgorithmSupportMessage;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.AuthenticatedCipherText;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.ContentCryptoProvider;
import macromedia.externals.com.nimbusds.jose_8_2_1.jca.JWEJCAContext;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.OctetSequenceKey;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64URL;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.ByteUtils;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Container;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class AESEncrypter
extends AESCryptoProvider
implements JWEEncrypter {
    public AESEncrypter(SecretKey secretKey) throws KeyLengthException {
        super(secretKey);
    }

    public AESEncrypter(byte[] byArray) throws KeyLengthException {
        this((SecretKey)new SecretKeySpec(byArray, "AES"));
    }

    public AESEncrypter(OctetSequenceKey octetSequenceKey) throws KeyLengthException {
        this(octetSequenceKey.toSecretKey("AES"));
    }

    public JWECryptoParts encrypt(JWEHeader jWEHeader, byte[] byArray) throws JOSEException {
        JWEHeader jWEHeader2;
        Base64URL base64URL;
        AlgFamily algFamily;
        JWEAlgorithm jWEAlgorithm = jWEHeader.getAlgorithm();
        if (jWEAlgorithm.equals((Object)JWEAlgorithm.A128KW)) {
            if (ByteUtils.safeBitLength((byte[])this.getKey().getEncoded()) != 128) {
                throw new KeyLengthException("The Key Encryption Key (KEK) length must be 128 bits for A128KW encryption");
            }
            algFamily = AlgFamily.AESKW;
        } else if (jWEAlgorithm.equals((Object)JWEAlgorithm.A192KW)) {
            if (ByteUtils.safeBitLength((byte[])this.getKey().getEncoded()) != 192) {
                throw new KeyLengthException("The Key Encryption Key (KEK) length must be 192 bits for A192KW encryption");
            }
            algFamily = AlgFamily.AESKW;
        } else if (jWEAlgorithm.equals((Object)JWEAlgorithm.A256KW)) {
            if (ByteUtils.safeBitLength((byte[])this.getKey().getEncoded()) != 256) {
                throw new KeyLengthException("The Key Encryption Key (KEK) length must be 256 bits for A256KW encryption");
            }
            algFamily = AlgFamily.AESKW;
        } else if (jWEAlgorithm.equals((Object)JWEAlgorithm.A128GCMKW)) {
            if (ByteUtils.safeBitLength((byte[])this.getKey().getEncoded()) != 128) {
                throw new KeyLengthException("The Key Encryption Key (KEK) length must be 128 bits for A128GCMKW encryption");
            }
            algFamily = AlgFamily.AESGCMKW;
        } else if (jWEAlgorithm.equals((Object)JWEAlgorithm.A192GCMKW)) {
            if (ByteUtils.safeBitLength((byte[])this.getKey().getEncoded()) != 192) {
                throw new KeyLengthException("The Key Encryption Key (KEK) length must be 192 bits for A192GCMKW encryption");
            }
            algFamily = AlgFamily.AESGCMKW;
        } else if (jWEAlgorithm.equals((Object)JWEAlgorithm.A256GCMKW)) {
            if (ByteUtils.safeBitLength((byte[])this.getKey().getEncoded()) != 256) {
                throw new KeyLengthException("The Key Encryption Key (KEK) length must be 256 bits for A256GCMKW encryption");
            }
            algFamily = AlgFamily.AESGCMKW;
        } else {
            throw new JOSEException(AlgorithmSupportMessage.unsupportedJWEAlgorithm((JWEAlgorithm)jWEAlgorithm, (Collection)SUPPORTED_ALGORITHMS));
        }
        EncryptionMethod encryptionMethod = jWEHeader.getEncryptionMethod();
        SecretKey secretKey = ContentCryptoProvider.generateCEK((EncryptionMethod)encryptionMethod, (SecureRandom)this.getJCAContext().getSecureRandom());
        if (AlgFamily.AESKW.equals((Object)algFamily)) {
            base64URL = Base64URL.encode((byte[])AESKW.wrapCEK((SecretKey)secretKey, (SecretKey)this.getKey(), (Provider)this.getJCAContext().getKeyEncryptionProvider()));
            jWEHeader2 = jWEHeader;
        } else if (AlgFamily.AESGCMKW.equals((Object)algFamily)) {
            Container container = new Container((Object)AESGCM.generateIV((SecureRandom)this.getJCAContext().getSecureRandom()));
            AuthenticatedCipherText authenticatedCipherText = AESGCMKW.encryptCEK((SecretKey)secretKey, (Container)container, (SecretKey)this.getKey(), (Provider)this.getJCAContext().getKeyEncryptionProvider());
            base64URL = Base64URL.encode((byte[])authenticatedCipherText.getCipherText());
            jWEHeader2 = new JWEHeader.Builder(jWEHeader).iv(Base64URL.encode((byte[])((byte[])container.get()))).authTag(Base64URL.encode((byte[])authenticatedCipherText.getAuthenticationTag())).build();
        } else {
            throw new JOSEException("Unexpected JWE algorithm: " + jWEAlgorithm);
        }
        return ContentCryptoProvider.encrypt((JWEHeader)jWEHeader2, (byte[])byArray, (SecretKey)secretKey, (Base64URL)base64URL, (JWEJCAContext)this.getJCAContext());
    }
}

