/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.crypto;

import java.security.Provider;
import java.util.Collection;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import macromedia.externals.com.nimbusds.jose_8_2_1.CriticalHeaderParamsAware;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEAlgorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEDecrypter;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEHeader;
import macromedia.externals.com.nimbusds.jose_8_2_1.KeyLengthException;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.AESCryptoProvider;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.AESGCMKW;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.AESKW;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.AlgorithmSupportMessage;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.AuthenticatedCipherText;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.ContentCryptoProvider;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.CriticalHeaderParamsDeferral;
import macromedia.externals.com.nimbusds.jose_8_2_1.jca.JWEJCAContext;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.OctetSequenceKey;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64URL;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class AESDecrypter
extends AESCryptoProvider
implements CriticalHeaderParamsAware,
JWEDecrypter {
    private final CriticalHeaderParamsDeferral critPolicy = new CriticalHeaderParamsDeferral();

    public AESDecrypter(SecretKey secretKey) throws KeyLengthException {
        this(secretKey, null);
    }

    public AESDecrypter(byte[] byArray) throws KeyLengthException {
        this((SecretKey)new SecretKeySpec(byArray, "AES"));
    }

    public AESDecrypter(OctetSequenceKey octetSequenceKey) throws KeyLengthException {
        this(octetSequenceKey.toSecretKey("AES"));
    }

    public AESDecrypter(SecretKey secretKey, Set<String> set) throws KeyLengthException {
        super(secretKey);
        this.critPolicy.setDeferredCriticalHeaderParams(set);
    }

    public Set<String> getProcessedCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    public Set<String> getDeferredCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    public byte[] decrypt(JWEHeader jWEHeader, Base64URL base64URL, Base64URL base64URL2, Base64URL base64URL3, Base64URL base64URL4) throws JOSEException {
        SecretKey secretKey;
        if (base64URL == null) {
            throw new JOSEException("Missing JWE encrypted key");
        }
        if (base64URL2 == null) {
            throw new JOSEException("Missing JWE initialization vector (IV)");
        }
        if (base64URL4 == null) {
            throw new JOSEException("Missing JWE authentication tag");
        }
        this.critPolicy.ensureHeaderPasses(jWEHeader);
        JWEAlgorithm jWEAlgorithm = jWEHeader.getAlgorithm();
        int n2 = jWEHeader.getEncryptionMethod().cekBitLength();
        if (jWEAlgorithm.equals((Object)JWEAlgorithm.A128KW) || jWEAlgorithm.equals((Object)JWEAlgorithm.A192KW) || jWEAlgorithm.equals((Object)JWEAlgorithm.A256KW)) {
            secretKey = AESKW.unwrapCEK((SecretKey)this.getKey(), (byte[])base64URL.decode(), (Provider)this.getJCAContext().getKeyEncryptionProvider());
        } else if (jWEAlgorithm.equals((Object)JWEAlgorithm.A128GCMKW) || jWEAlgorithm.equals((Object)JWEAlgorithm.A192GCMKW) || jWEAlgorithm.equals((Object)JWEAlgorithm.A256GCMKW)) {
            if (jWEHeader.getIV() == null) {
                throw new JOSEException("Missing JWE \"iv\" header parameter");
            }
            byte[] byArray = jWEHeader.getIV().decode();
            if (jWEHeader.getAuthTag() == null) {
                throw new JOSEException("Missing JWE \"tag\" header parameter");
            }
            byte[] byArray2 = jWEHeader.getAuthTag().decode();
            AuthenticatedCipherText authenticatedCipherText = new AuthenticatedCipherText(base64URL.decode(), byArray2);
            secretKey = AESGCMKW.decryptCEK((SecretKey)this.getKey(), (byte[])byArray, (AuthenticatedCipherText)authenticatedCipherText, (int)n2, (Provider)this.getJCAContext().getKeyEncryptionProvider());
        } else {
            throw new JOSEException(AlgorithmSupportMessage.unsupportedJWEAlgorithm((JWEAlgorithm)jWEAlgorithm, (Collection)SUPPORTED_ALGORITHMS));
        }
        return ContentCryptoProvider.decrypt((JWEHeader)jWEHeader, (Base64URL)base64URL, (Base64URL)base64URL2, (Base64URL)base64URL3, (Base64URL)base64URL4, (SecretKey)secretKey, (JWEJCAContext)this.getJCAContext());
    }
}

