/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1;

import java.text.ParseException;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEObject;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSHeader;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSObject;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSSigner;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSVerifier;
import macromedia.externals.com.nimbusds.jose_8_2_1.Payload;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64URL;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.StandardCharset;
import net.jcip.annotations.ThreadSafe;

/*
 * Exception performing whole class analysis ignored.
 */
@ThreadSafe
public class JWSObject
extends JOSEObject {
    private static final long serialVersionUID = 1L;
    private final JWSHeader header;
    private final String signingInputString;
    private Base64URL signature;
    private State state;

    public JWSObject(JWSHeader jWSHeader, Payload payload) {
        if (jWSHeader == null) {
            throw new IllegalArgumentException("The JWS header must not be null");
        }
        this.header = jWSHeader;
        if (payload == null) {
            throw new IllegalArgumentException("The payload must not be null");
        }
        this.setPayload(payload);
        this.signingInputString = jWSHeader.getCustomParam("b64") == null || (Boolean)jWSHeader.getCustomParam("b64") != false ? JWSObject.composeSigningInput((Base64URL)jWSHeader.toBase64URL(), (Base64URL)payload.toBase64URL()) : jWSHeader.toBase64URL().toString() + '.' + payload.toString();
        this.signature = null;
        this.state = State.UNSIGNED;
    }

    public JWSObject(Base64URL base64URL, Base64URL base64URL2, Base64URL base64URL3) throws ParseException {
        if (base64URL == null) {
            throw new IllegalArgumentException("The first part must not be null");
        }
        try {
            this.header = JWSHeader.parse((Base64URL)base64URL);
        }
        catch (ParseException parseException) {
            throw new ParseException("Invalid JWS header: " + parseException.getMessage(), 0);
        }
        if (base64URL2 == null) {
            throw new IllegalArgumentException("The second part must not be null");
        }
        this.setPayload(new Payload(base64URL2));
        this.signingInputString = JWSObject.composeSigningInput((Base64URL)base64URL, (Base64URL)base64URL2);
        if (base64URL3 == null) {
            throw new IllegalArgumentException("The third part must not be null");
        }
        this.signature = base64URL3;
        this.state = State.SIGNED;
        this.setParsedParts(new Base64URL[]{base64URL, base64URL2, base64URL3});
    }

    public JWSHeader getHeader() {
        return this.header;
    }

    private static String composeSigningInput(Base64URL base64URL, Base64URL base64URL2) {
        return base64URL.toString() + '.' + base64URL2.toString();
    }

    public byte[] getSigningInput() {
        return this.signingInputString.getBytes(StandardCharset.UTF_8);
    }

    public Base64URL getSignature() {
        return this.signature;
    }

    public State getState() {
        return this.state;
    }

    private void ensureUnsignedState() {
        if (this.state != State.UNSIGNED) {
            throw new IllegalStateException("The JWS object must be in an unsigned state");
        }
    }

    private void ensureSignedOrVerifiedState() {
        if (this.state != State.SIGNED && this.state != State.VERIFIED) {
            throw new IllegalStateException("The JWS object must be in a signed or verified state");
        }
    }

    private void ensureJWSSignerSupport(JWSSigner jWSSigner) throws JOSEException {
        if (!jWSSigner.supportedJWSAlgorithms().contains(this.getHeader().getAlgorithm())) {
            throw new JOSEException("The \"" + this.getHeader().getAlgorithm() + "\" algorithm is not allowed or supported by the JWS signer: Supported algorithms: " + jWSSigner.supportedJWSAlgorithms());
        }
    }

    public synchronized void sign(JWSSigner jWSSigner) throws JOSEException {
        this.ensureUnsignedState();
        this.ensureJWSSignerSupport(jWSSigner);
        try {
            this.signature = jWSSigner.sign(this.getHeader(), this.getSigningInput());
        }
        catch (JOSEException jOSEException) {
            throw jOSEException;
        }
        catch (Exception exception) {
            throw new JOSEException(exception.getMessage(), (Throwable)exception);
        }
        this.state = State.SIGNED;
    }

    public synchronized boolean verify(JWSVerifier jWSVerifier) throws JOSEException {
        boolean bl2;
        this.ensureSignedOrVerifiedState();
        try {
            bl2 = jWSVerifier.verify(this.getHeader(), this.getSigningInput(), this.getSignature());
        }
        catch (JOSEException jOSEException) {
            throw jOSEException;
        }
        catch (Exception exception) {
            throw new JOSEException(exception.getMessage(), (Throwable)exception);
        }
        if (bl2) {
            this.state = State.VERIFIED;
        }
        return bl2;
    }

    public String serialize() {
        return this.serialize(false);
    }

    public String serialize(boolean bl2) {
        this.ensureSignedOrVerifiedState();
        if (bl2) {
            return this.header.toBase64URL().toString() + '.' + '.' + this.signature.toString();
        }
        return this.signingInputString + '.' + this.signature.toString();
    }

    public static JWSObject parse(String string) throws ParseException {
        Base64URL[] base64URLArray = JOSEObject.split((String)string);
        if (base64URLArray.length != 3) {
            throw new ParseException("Unexpected number of Base64URL parts, must be three", 0);
        }
        return new JWSObject(base64URLArray[0], base64URLArray[1], base64URLArray[2]);
    }
}

