/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1;

import java.net.URI;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.externals.com.nimbusds.jose_8_2_1.Algorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.CommonSEHeader;
import macromedia.externals.com.nimbusds.jose_8_2_1.Header;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEObjectType;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSAlgorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSHeader;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.JWK;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64URL;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.JSONObjectUtils;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.X509CertChainUtils;
import macromedia.externals.net.minidev.json_1_3_1.JSONArray;
import macromedia.externals.net.minidev.json_1_3_1.JSONObject;
import net.jcip.annotations.Immutable;

/*
 * Exception performing whole class analysis ignored.
 */
@Immutable
public final class JWSHeader
extends CommonSEHeader {
    private static final long serialVersionUID = 1L;
    private static final Set<String> REGISTERED_PARAMETER_NAMES;

    public JWSHeader(JWSAlgorithm jWSAlgorithm) {
        this(jWSAlgorithm, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public JWSHeader(JWSAlgorithm jWSAlgorithm, JOSEObjectType jOSEObjectType, String string, Set<String> set, URI uRI, JWK jWK, URI uRI2, Base64URL base64URL, Base64URL base64URL2, List<Base64> list, String string2, Map<String, Object> map, Base64URL base64URL3) {
        super((Algorithm)jWSAlgorithm, jOSEObjectType, string, set, uRI, jWK, uRI2, base64URL, base64URL2, list, string2, map, base64URL3);
        if (jWSAlgorithm.getName().equals(Algorithm.NONE.getName())) {
            throw new IllegalArgumentException("The JWS algorithm \"alg\" cannot be \"none\"");
        }
    }

    public JWSHeader(JWSHeader jWSHeader) {
        this(jWSHeader.getAlgorithm(), jWSHeader.getType(), jWSHeader.getContentType(), jWSHeader.getCriticalParams(), jWSHeader.getJWKURL(), jWSHeader.getJWK(), jWSHeader.getX509CertURL(), jWSHeader.getX509CertThumbprint(), jWSHeader.getX509CertSHA256Thumbprint(), jWSHeader.getX509CertChain(), jWSHeader.getKeyID(), jWSHeader.getCustomParams(), jWSHeader.getParsedBase64URL());
    }

    public static Set<String> getRegisteredParameterNames() {
        return REGISTERED_PARAMETER_NAMES;
    }

    public JWSAlgorithm getAlgorithm() {
        return (JWSAlgorithm)super.getAlgorithm();
    }

    public static JWSHeader parse(JSONObject jSONObject) throws ParseException {
        return JWSHeader.parse((JSONObject)jSONObject, null);
    }

    public static JWSHeader parse(JSONObject jSONObject, Base64URL base64URL) throws ParseException {
        Algorithm algorithm = Header.parseAlgorithm((JSONObject)jSONObject);
        if (!(algorithm instanceof JWSAlgorithm)) {
            throw new ParseException("The algorithm \"alg\" header parameter must be for signatures", 0);
        }
        Builder builder = new Builder((JWSAlgorithm)algorithm).parsedBase64URL(base64URL);
        for (String string : jSONObject.keySet()) {
            Object object;
            if ("alg".equals(string)) continue;
            if ("typ".equals(string)) {
                object = JSONObjectUtils.getString((JSONObject)jSONObject, (String)string);
                if (object == null) continue;
                builder = builder.type(new JOSEObjectType((String)object));
                continue;
            }
            if ("cty".equals(string)) {
                builder = builder.contentType(JSONObjectUtils.getString((JSONObject)jSONObject, (String)string));
                continue;
            }
            if ("crit".equals(string)) {
                object = JSONObjectUtils.getStringList((JSONObject)jSONObject, (String)string);
                if (object == null) continue;
                builder = builder.criticalParams(new HashSet(object));
                continue;
            }
            if ("jku".equals(string)) {
                builder = builder.jwkURL(JSONObjectUtils.getURI((JSONObject)jSONObject, (String)string));
                continue;
            }
            if ("jwk".equals(string)) {
                object = JSONObjectUtils.getJSONObject((JSONObject)jSONObject, (String)string);
                if (object == null) continue;
                builder = builder.jwk(JWK.parse((JSONObject)object));
                continue;
            }
            if ("x5u".equals(string)) {
                builder = builder.x509CertURL(JSONObjectUtils.getURI((JSONObject)jSONObject, (String)string));
                continue;
            }
            if ("x5t".equals(string)) {
                builder = builder.x509CertThumbprint(Base64URL.from((String)JSONObjectUtils.getString((JSONObject)jSONObject, (String)string)));
                continue;
            }
            if ("x5t#S256".equals(string)) {
                builder = builder.x509CertSHA256Thumbprint(Base64URL.from((String)JSONObjectUtils.getString((JSONObject)jSONObject, (String)string)));
                continue;
            }
            if ("x5c".equals(string)) {
                builder = builder.x509CertChain(X509CertChainUtils.toBase64List((JSONArray)JSONObjectUtils.getJSONArray((JSONObject)jSONObject, (String)string)));
                continue;
            }
            if ("kid".equals(string)) {
                builder = builder.keyID(JSONObjectUtils.getString((JSONObject)jSONObject, (String)string));
                continue;
            }
            builder = builder.customParam(string, jSONObject.get((Object)string));
        }
        return builder.build();
    }

    public static JWSHeader parse(String string) throws ParseException {
        return JWSHeader.parse((String)string, null);
    }

    public static JWSHeader parse(String string, Base64URL base64URL) throws ParseException {
        return JWSHeader.parse((JSONObject)JSONObjectUtils.parse((String)string), (Base64URL)base64URL);
    }

    public static JWSHeader parse(Base64URL base64URL) throws ParseException {
        return JWSHeader.parse((String)base64URL.decodeToString(), (Base64URL)base64URL);
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("alg");
        hashSet.add("jku");
        hashSet.add("jwk");
        hashSet.add("x5u");
        hashSet.add("x5t");
        hashSet.add("x5t#S256");
        hashSet.add("x5c");
        hashSet.add("kid");
        hashSet.add("typ");
        hashSet.add("cty");
        hashSet.add("crit");
        REGISTERED_PARAMETER_NAMES = Collections.unmodifiableSet(hashSet);
    }
}

