/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1;

import java.net.URI;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.externals.com.nimbusds.jose_8_2_1.Algorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.CommonSEHeader;
import macromedia.externals.com.nimbusds.jose_8_2_1.CompressionAlgorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.EncryptionMethod;
import macromedia.externals.com.nimbusds.jose_8_2_1.Header;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEObjectType;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEAlgorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEHeader;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.JWK;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64URL;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.JSONObjectUtils;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.X509CertChainUtils;
import macromedia.externals.net.minidev.json_1_3_1.JSONArray;
import macromedia.externals.net.minidev.json_1_3_1.JSONObject;
import net.jcip.annotations.Immutable;

/*
 * Exception performing whole class analysis ignored.
 */
@Immutable
public final class JWEHeader
extends CommonSEHeader {
    private static final long serialVersionUID = 1L;
    private static final Set<String> REGISTERED_PARAMETER_NAMES;
    private final EncryptionMethod enc;
    private final JWK epk;
    private final CompressionAlgorithm zip;
    private final Base64URL apu;
    private final Base64URL apv;
    private final Base64URL p2s;
    private final int p2c;
    private final Base64URL iv;
    private final Base64URL tag;

    public JWEHeader(JWEAlgorithm jWEAlgorithm, EncryptionMethod encryptionMethod) {
        this((Algorithm)jWEAlgorithm, encryptionMethod, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0, null, null, null, null);
    }

    public JWEHeader(Algorithm algorithm, EncryptionMethod encryptionMethod, JOSEObjectType jOSEObjectType, String string, Set<String> set, URI uRI, JWK jWK, URI uRI2, Base64URL base64URL, Base64URL base64URL2, List<Base64> list, String string2, JWK jWK2, CompressionAlgorithm compressionAlgorithm, Base64URL base64URL3, Base64URL base64URL4, Base64URL base64URL5, int n2, Base64URL base64URL6, Base64URL base64URL7, Map<String, Object> map, Base64URL base64URL8) {
        super(algorithm, jOSEObjectType, string, set, uRI, jWK, uRI2, base64URL, base64URL2, list, string2, map, base64URL8);
        if (algorithm.getName().equals(Algorithm.NONE.getName())) {
            throw new IllegalArgumentException("The JWE algorithm cannot be \"none\"");
        }
        if (encryptionMethod == null) {
            throw new IllegalArgumentException("The encryption method \"enc\" parameter must not be null");
        }
        if (jWK2 != null && jWK2.isPrivate()) {
            throw new IllegalArgumentException("Ephemeral public key should not be a private key");
        }
        this.enc = encryptionMethod;
        this.epk = jWK2;
        this.zip = compressionAlgorithm;
        this.apu = base64URL3;
        this.apv = base64URL4;
        this.p2s = base64URL5;
        this.p2c = n2;
        this.iv = base64URL6;
        this.tag = base64URL7;
    }

    public JWEHeader(JWEHeader jWEHeader) {
        this((Algorithm)jWEHeader.getAlgorithm(), jWEHeader.getEncryptionMethod(), jWEHeader.getType(), jWEHeader.getContentType(), jWEHeader.getCriticalParams(), jWEHeader.getJWKURL(), jWEHeader.getJWK(), jWEHeader.getX509CertURL(), jWEHeader.getX509CertThumbprint(), jWEHeader.getX509CertSHA256Thumbprint(), jWEHeader.getX509CertChain(), jWEHeader.getKeyID(), jWEHeader.getEphemeralPublicKey(), jWEHeader.getCompressionAlgorithm(), jWEHeader.getAgreementPartyUInfo(), jWEHeader.getAgreementPartyVInfo(), jWEHeader.getPBES2Salt(), jWEHeader.getPBES2Count(), jWEHeader.getIV(), jWEHeader.getAuthTag(), jWEHeader.getCustomParams(), jWEHeader.getParsedBase64URL());
    }

    public static Set<String> getRegisteredParameterNames() {
        return REGISTERED_PARAMETER_NAMES;
    }

    public JWEAlgorithm getAlgorithm() {
        return (JWEAlgorithm)super.getAlgorithm();
    }

    public EncryptionMethod getEncryptionMethod() {
        return this.enc;
    }

    public JWK getEphemeralPublicKey() {
        return this.epk;
    }

    public CompressionAlgorithm getCompressionAlgorithm() {
        return this.zip;
    }

    public Base64URL getAgreementPartyUInfo() {
        return this.apu;
    }

    public Base64URL getAgreementPartyVInfo() {
        return this.apv;
    }

    public Base64URL getPBES2Salt() {
        return this.p2s;
    }

    public int getPBES2Count() {
        return this.p2c;
    }

    public Base64URL getIV() {
        return this.iv;
    }

    public Base64URL getAuthTag() {
        return this.tag;
    }

    public Set<String> getIncludedParams() {
        Set set = super.getIncludedParams();
        if (this.enc != null) {
            set.add("enc");
        }
        if (this.epk != null) {
            set.add("epk");
        }
        if (this.zip != null) {
            set.add("zip");
        }
        if (this.apu != null) {
            set.add("apu");
        }
        if (this.apv != null) {
            set.add("apv");
        }
        if (this.p2s != null) {
            set.add("p2s");
        }
        if (this.p2c > 0) {
            set.add("p2c");
        }
        if (this.iv != null) {
            set.add("iv");
        }
        if (this.tag != null) {
            set.add("tag");
        }
        return set;
    }

    public JSONObject toJSONObject() {
        JSONObject jSONObject = super.toJSONObject();
        if (this.enc != null) {
            jSONObject.put((Object)"enc", (Object)this.enc.toString());
        }
        if (this.epk != null) {
            jSONObject.put((Object)"epk", (Object)this.epk.toJSONObject());
        }
        if (this.zip != null) {
            jSONObject.put((Object)"zip", (Object)this.zip.toString());
        }
        if (this.apu != null) {
            jSONObject.put((Object)"apu", (Object)this.apu.toString());
        }
        if (this.apv != null) {
            jSONObject.put((Object)"apv", (Object)this.apv.toString());
        }
        if (this.p2s != null) {
            jSONObject.put((Object)"p2s", (Object)this.p2s.toString());
        }
        if (this.p2c > 0) {
            jSONObject.put((Object)"p2c", (Object)this.p2c);
        }
        if (this.iv != null) {
            jSONObject.put((Object)"iv", (Object)this.iv.toString());
        }
        if (this.tag != null) {
            jSONObject.put((Object)"tag", (Object)this.tag.toString());
        }
        return jSONObject;
    }

    private static EncryptionMethod parseEncryptionMethod(JSONObject jSONObject) throws ParseException {
        return EncryptionMethod.parse((String)JSONObjectUtils.getString((JSONObject)jSONObject, (String)"enc"));
    }

    public static JWEHeader parse(JSONObject jSONObject) throws ParseException {
        return JWEHeader.parse((JSONObject)jSONObject, null);
    }

    public static JWEHeader parse(JSONObject jSONObject, Base64URL base64URL) throws ParseException {
        Algorithm algorithm = Header.parseAlgorithm((JSONObject)jSONObject);
        if (!(algorithm instanceof JWEAlgorithm)) {
            throw new ParseException("The algorithm \"alg\" header parameter must be for encryption", 0);
        }
        EncryptionMethod encryptionMethod = JWEHeader.parseEncryptionMethod((JSONObject)jSONObject);
        Builder builder = new Builder((JWEAlgorithm)algorithm, encryptionMethod).parsedBase64URL(base64URL);
        for (String string : jSONObject.keySet()) {
            Object object;
            if ("alg".equals(string) || "enc".equals(string)) continue;
            if ("typ".equals(string)) {
                object = JSONObjectUtils.getString((JSONObject)jSONObject, (String)string);
                if (object == null) continue;
                builder = builder.type(new JOSEObjectType((String)object));
                continue;
            }
            if ("cty".equals(string)) {
                builder = builder.contentType(JSONObjectUtils.getString((JSONObject)jSONObject, (String)string));
                continue;
            }
            if ("crit".equals(string)) {
                object = JSONObjectUtils.getStringList((JSONObject)jSONObject, (String)string);
                if (object == null) continue;
                builder = builder.criticalParams(new HashSet(object));
                continue;
            }
            if ("jku".equals(string)) {
                builder = builder.jwkURL(JSONObjectUtils.getURI((JSONObject)jSONObject, (String)string));
                continue;
            }
            if ("jwk".equals(string)) {
                object = JSONObjectUtils.getJSONObject((JSONObject)jSONObject, (String)string);
                if (object == null) continue;
                builder = builder.jwk(JWK.parse((JSONObject)object));
                continue;
            }
            if ("x5u".equals(string)) {
                builder = builder.x509CertURL(JSONObjectUtils.getURI((JSONObject)jSONObject, (String)string));
                continue;
            }
            if ("x5t".equals(string)) {
                builder = builder.x509CertThumbprint(Base64URL.from((String)JSONObjectUtils.getString((JSONObject)jSONObject, (String)string)));
                continue;
            }
            if ("x5t#S256".equals(string)) {
                builder = builder.x509CertSHA256Thumbprint(Base64URL.from((String)JSONObjectUtils.getString((JSONObject)jSONObject, (String)string)));
                continue;
            }
            if ("x5c".equals(string)) {
                builder = builder.x509CertChain(X509CertChainUtils.toBase64List((JSONArray)JSONObjectUtils.getJSONArray((JSONObject)jSONObject, (String)string)));
                continue;
            }
            if ("kid".equals(string)) {
                builder = builder.keyID(JSONObjectUtils.getString((JSONObject)jSONObject, (String)string));
                continue;
            }
            if ("epk".equals(string)) {
                builder = builder.ephemeralPublicKey(JWK.parse((JSONObject)JSONObjectUtils.getJSONObject((JSONObject)jSONObject, (String)string)));
                continue;
            }
            if ("zip".equals(string)) {
                object = JSONObjectUtils.getString((JSONObject)jSONObject, (String)string);
                if (object == null) continue;
                builder = builder.compressionAlgorithm(new CompressionAlgorithm((String)object));
                continue;
            }
            if ("apu".equals(string)) {
                builder = builder.agreementPartyUInfo(Base64URL.from((String)JSONObjectUtils.getString((JSONObject)jSONObject, (String)string)));
                continue;
            }
            if ("apv".equals(string)) {
                builder = builder.agreementPartyVInfo(Base64URL.from((String)JSONObjectUtils.getString((JSONObject)jSONObject, (String)string)));
                continue;
            }
            if ("p2s".equals(string)) {
                builder = builder.pbes2Salt(Base64URL.from((String)JSONObjectUtils.getString((JSONObject)jSONObject, (String)string)));
                continue;
            }
            if ("p2c".equals(string)) {
                builder = builder.pbes2Count(JSONObjectUtils.getInt((JSONObject)jSONObject, (String)string));
                continue;
            }
            if ("iv".equals(string)) {
                builder = builder.iv(Base64URL.from((String)JSONObjectUtils.getString((JSONObject)jSONObject, (String)string)));
                continue;
            }
            if ("tag".equals(string)) {
                builder = builder.authTag(Base64URL.from((String)JSONObjectUtils.getString((JSONObject)jSONObject, (String)string)));
                continue;
            }
            builder = builder.customParam(string, jSONObject.get((Object)string));
        }
        return builder.build();
    }

    public static JWEHeader parse(String string) throws ParseException {
        return JWEHeader.parse((JSONObject)JSONObjectUtils.parse((String)string), null);
    }

    public static JWEHeader parse(String string, Base64URL base64URL) throws ParseException {
        return JWEHeader.parse((JSONObject)JSONObjectUtils.parse((String)string), (Base64URL)base64URL);
    }

    public static JWEHeader parse(Base64URL base64URL) throws ParseException {
        return JWEHeader.parse((String)base64URL.decodeToString(), (Base64URL)base64URL);
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("alg");
        hashSet.add("enc");
        hashSet.add("epk");
        hashSet.add("zip");
        hashSet.add("jku");
        hashSet.add("jwk");
        hashSet.add("x5u");
        hashSet.add("x5t");
        hashSet.add("x5t#S256");
        hashSet.add("x5c");
        hashSet.add("kid");
        hashSet.add("typ");
        hashSet.add("cty");
        hashSet.add("crit");
        hashSet.add("apu");
        hashSet.add("apv");
        hashSet.add("p2s");
        hashSet.add("p2c");
        hashSet.add("iv");
        hashSet.add("authTag");
        REGISTERED_PARAMETER_NAMES = Collections.unmodifiableSet(hashSet);
    }
}

