/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1;

import macromedia.externals.com.nimbusds.jose_8_2_1.Algorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.Requirement;
import net.jcip.annotations.Immutable;

@Immutable
public final class JWEAlgorithm
extends Algorithm {
    private static final long serialVersionUID = 1L;
    @Deprecated
    public static final JWEAlgorithm RSA1_5 = new JWEAlgorithm("RSA1_5", Requirement.REQUIRED);
    @Deprecated
    public static final JWEAlgorithm RSA_OAEP = new JWEAlgorithm("RSA-OAEP", Requirement.OPTIONAL);
    public static final JWEAlgorithm RSA_OAEP_256 = new JWEAlgorithm("RSA-OAEP-256", Requirement.OPTIONAL);
    public static final JWEAlgorithm A128KW = new JWEAlgorithm("A128KW", Requirement.RECOMMENDED);
    public static final JWEAlgorithm A192KW = new JWEAlgorithm("A192KW", Requirement.OPTIONAL);
    public static final JWEAlgorithm A256KW = new JWEAlgorithm("A256KW", Requirement.RECOMMENDED);
    public static final JWEAlgorithm DIR = new JWEAlgorithm("dir", Requirement.RECOMMENDED);
    public static final JWEAlgorithm ECDH_ES = new JWEAlgorithm("ECDH-ES", Requirement.RECOMMENDED);
    public static final JWEAlgorithm ECDH_ES_A128KW = new JWEAlgorithm("ECDH-ES+A128KW", Requirement.RECOMMENDED);
    public static final JWEAlgorithm ECDH_ES_A192KW = new JWEAlgorithm("ECDH-ES+A192KW", Requirement.OPTIONAL);
    public static final JWEAlgorithm ECDH_ES_A256KW = new JWEAlgorithm("ECDH-ES+A256KW", Requirement.RECOMMENDED);
    public static final JWEAlgorithm A128GCMKW = new JWEAlgorithm("A128GCMKW", Requirement.OPTIONAL);
    public static final JWEAlgorithm A192GCMKW = new JWEAlgorithm("A192GCMKW", Requirement.OPTIONAL);
    public static final JWEAlgorithm A256GCMKW = new JWEAlgorithm("A256GCMKW", Requirement.OPTIONAL);
    public static final JWEAlgorithm PBES2_HS256_A128KW = new JWEAlgorithm("PBES2-HS256+A128KW", Requirement.OPTIONAL);
    public static final JWEAlgorithm PBES2_HS384_A192KW = new JWEAlgorithm("PBES2-HS384+A192KW", Requirement.OPTIONAL);
    public static final JWEAlgorithm PBES2_HS512_A256KW = new JWEAlgorithm("PBES2-HS512+A256KW", Requirement.OPTIONAL);

    public JWEAlgorithm(String string, Requirement requirement) {
        super(string, requirement);
    }

    public JWEAlgorithm(String string) {
        super(string, null);
    }

    public static JWEAlgorithm parse(String string) {
        if (string.equals(RSA1_5.getName())) {
            return RSA1_5;
        }
        if (string.equals(RSA_OAEP.getName())) {
            return RSA_OAEP;
        }
        if (string.equals(RSA_OAEP_256.getName())) {
            return RSA_OAEP_256;
        }
        if (string.equals(A128KW.getName())) {
            return A128KW;
        }
        if (string.equals(A192KW.getName())) {
            return A192KW;
        }
        if (string.equals(A256KW.getName())) {
            return A256KW;
        }
        if (string.equals(DIR.getName())) {
            return DIR;
        }
        if (string.equals(ECDH_ES.getName())) {
            return ECDH_ES;
        }
        if (string.equals(ECDH_ES_A128KW.getName())) {
            return ECDH_ES_A128KW;
        }
        if (string.equals(ECDH_ES_A192KW.getName())) {
            return ECDH_ES_A192KW;
        }
        if (string.equals(ECDH_ES_A256KW.getName())) {
            return ECDH_ES_A256KW;
        }
        if (string.equals(A128GCMKW.getName())) {
            return A128GCMKW;
        }
        if (string.equals(A192GCMKW.getName())) {
            return A192GCMKW;
        }
        if (string.equals(A256GCMKW.getName())) {
            return A256GCMKW;
        }
        if (string.equals(PBES2_HS256_A128KW.getName())) {
            return PBES2_HS256_A128KW;
        }
        if (string.equals(PBES2_HS384_A192KW.getName())) {
            return PBES2_HS384_A192KW;
        }
        if (string.equals(PBES2_HS512_A256KW.getName())) {
            return PBES2_HS512_A256KW;
        }
        return new JWEAlgorithm(string);
    }
}

